# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.cosmosdb import CosmosDBManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCosmosDBManagementTableResourcesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CosmosDBManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_list_tables(self, resource_group):
        response = self.client.table_resources.list_tables(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-12-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_get_table(self, resource_group):
        response = self.client.table_resources.get_table(
            resource_group_name=resource_group.name,
            account_name="str",
            table_name="str",
            api_version="2024-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_begin_create_update_table(self, resource_group):
        response = self.client.table_resources.begin_create_update_table(
            resource_group_name=resource_group.name,
            account_name="str",
            table_name="str",
            create_update_table_parameters={
                "resource": {
                    "id": "str",
                    "createMode": "Default",
                    "restoreParameters": {
                        "restoreSource": "str",
                        "restoreTimestampInUtc": "2020-02-20 00:00:00",
                        "restoreWithTtlDisabled": bool,
                    },
                },
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "name": "str",
                "options": {"autoscaleSettings": {"maxThroughput": 0}, "throughput": 0},
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-12-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_begin_delete_table(self, resource_group):
        response = self.client.table_resources.begin_delete_table(
            resource_group_name=resource_group.name,
            account_name="str",
            table_name="str",
            api_version="2024-12-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_get_table_throughput(self, resource_group):
        response = self.client.table_resources.get_table_throughput(
            resource_group_name=resource_group.name,
            account_name="str",
            table_name="str",
            api_version="2024-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_begin_update_table_throughput(self, resource_group):
        response = self.client.table_resources.begin_update_table_throughput(
            resource_group_name=resource_group.name,
            account_name="str",
            table_name="str",
            update_throughput_parameters={
                "resource": {
                    "autoscaleSettings": {
                        "maxThroughput": 0,
                        "autoUpgradePolicy": {"throughputPolicy": {"incrementPercent": 0, "isEnabled": bool}},
                        "targetMaxThroughput": 0,
                    },
                    "instantMaximumThroughput": "str",
                    "minimumThroughput": "str",
                    "offerReplacePending": "str",
                    "softAllowedMaximumThroughput": "str",
                    "throughput": 0,
                    "throughputBuckets": [{"id": 0, "maxThroughputPercentage": 0}],
                },
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "location": "str",
                "name": "str",
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-12-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_begin_migrate_table_to_autoscale(self, resource_group):
        response = self.client.table_resources.begin_migrate_table_to_autoscale(
            resource_group_name=resource_group.name,
            account_name="str",
            table_name="str",
            api_version="2024-12-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_begin_migrate_table_to_manual_throughput(self, resource_group):
        response = self.client.table_resources.begin_migrate_table_to_manual_throughput(
            resource_group_name=resource_group.name,
            account_name="str",
            table_name="str",
            api_version="2024-12-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_begin_retrieve_continuous_backup_information(self, resource_group):
        response = self.client.table_resources.begin_retrieve_continuous_backup_information(
            resource_group_name=resource_group.name,
            account_name="str",
            table_name="str",
            location={"location": "str"},
            api_version="2024-12-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_get_table_role_definition(self, resource_group):
        response = self.client.table_resources.get_table_role_definition(
            resource_group_name=resource_group.name,
            account_name="str",
            role_definition_id="str",
            api_version="2024-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_begin_create_update_table_role_definition(self, resource_group):
        response = self.client.table_resources.begin_create_update_table_role_definition(
            resource_group_name=resource_group.name,
            account_name="str",
            role_definition_id="str",
            create_update_table_role_definition_parameters={
                "assignableScopes": ["str"],
                "id": "str",
                "name": "str",
                "permissions": [{"dataActions": ["str"], "id": "str", "notDataActions": ["str"]}],
                "roleName": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2024-12-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_begin_delete_table_role_definition(self, resource_group):
        response = self.client.table_resources.begin_delete_table_role_definition(
            resource_group_name=resource_group.name,
            account_name="str",
            role_definition_id="str",
            api_version="2024-12-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_list_table_role_definitions(self, resource_group):
        response = self.client.table_resources.list_table_role_definitions(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-12-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_get_table_role_assignment(self, resource_group):
        response = self.client.table_resources.get_table_role_assignment(
            resource_group_name=resource_group.name,
            account_name="str",
            role_assignment_id="str",
            api_version="2024-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_begin_create_update_table_role_assignment(self, resource_group):
        response = self.client.table_resources.begin_create_update_table_role_assignment(
            resource_group_name=resource_group.name,
            account_name="str",
            role_assignment_id="str",
            create_update_table_role_assignment_parameters={
                "id": "str",
                "name": "str",
                "principalId": "str",
                "provisioningState": "str",
                "roleDefinitionId": "str",
                "scope": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2024-12-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_begin_delete_table_role_assignment(self, resource_group):
        response = self.client.table_resources.begin_delete_table_role_assignment(
            resource_group_name=resource_group.name,
            account_name="str",
            role_assignment_id="str",
            api_version="2024-12-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_table_resources_list_table_role_assignments(self, resource_group):
        response = self.client.table_resources.list_table_role_assignments(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2024-12-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
