# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.managednetworkfabric import ManagedNetworkFabricMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-managednetworkfabric
# USAGE
    python internal_networks_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ManagedNetworkFabricMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="subscriptionId",
    )

    response = client.internal_networks.begin_update(
        resource_group_name="resourceGroupName",
        l3_isolation_domain_name="example-l3domain",
        internal_network_name="example-internalnetwork",
        body={
            "properties": {
                "bgpConfiguration": {
                    "allowAS": 1,
                    "allowASOverride": "Enable",
                    "bfdConfiguration": {},
                    "defaultRouteOriginate": "True",
                    "ipv4ListenRangePrefixes": ["10.1.0.0/25"],
                    "ipv4NeighborAddress": [{"address": "10.1.0.0"}],
                    "ipv6ListenRangePrefixes": ["2fff::/66"],
                    "ipv6NeighborAddress": [{"address": "2fff::"}],
                    "peerASN": 6,
                },
                "connectedIPv4Subnets": [{"prefix": "10.0.0.0/24"}],
                "connectedIPv6Subnets": [{"prefix": "3FFE:FFFF:0:CD30::a0/29"}],
                "exportRoutePolicyId": "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName2",
                "importRoutePolicyId": "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/routePolicies/routePolicyName1",
                "mtu": 1500,
                "staticRouteConfiguration": {
                    "bfdConfiguration": {},
                    "ipv4Routes": [{"nextHop": ["10.0.0.1"], "prefix": "10.1.0.0/24"}],
                    "ipv6Routes": [{"nextHop": ["2ffe::1"], "prefix": "2fff::/64"}],
                },
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/managednetworkfabric/resource-manager/Microsoft.ManagedNetworkFabric/preview/2023-02-01-preview/examples/InternalNetworks_Update_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
