# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class CheckNameAvailabilityParameters(msrest.serialization.Model):
    """Input values.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the service instance to check.
    :type name: str
    :param type: Required. The fully qualified resource type which includes provider namespace.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']


class ResourceCore(msrest.serialization.Model):
    """The common properties for any resource, tracked or proxy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param etag: An etag associated with the resource, used for optimistic concurrency when editing
     it.
    :type etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[a-z0-9][a-z0-9-]{1,21}[a-z0-9]$'},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceCore, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = kwargs.get('etag', None)


class LocationBasedResource(ResourceCore):
    """The common properties for any location based resource, tracked or proxy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param etag: An etag associated with the resource, used for optimistic concurrency when editing
     it.
    :type etag: str
    :param location: The resource location.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[a-z0-9][a-z0-9-]{1,21}[a-z0-9]$'},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocationBasedResource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)


class ResourceTags(msrest.serialization.Model):
    """List of key value pairs that describe the resource. This will overwrite the existing tags.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceTags, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class TaggedResource(ResourceTags, LocationBasedResource):
    """The common properties of tracked resources in the service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param etag: An etag associated with the resource, used for optimistic concurrency when editing
     it.
    :type etag: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[a-z0-9][a-z0-9-]{1,21}[a-z0-9]$'},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaggedResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = kwargs.get('etag', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class DicomService(TaggedResource):
    """The description of Dicom Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param etag: An etag associated with the resource, used for optimistic concurrency when editing
     it.
    :type etag: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthcareapis.models.SystemData
    :param provisioning_state: The provisioning state. Possible values include: "Deleting",
     "Succeeded", "Creating", "Accepted", "Verifying", "Updating", "Failed", "Canceled",
     "Deprovisioned", "Moving", "Suspended", "Warned", "SystemMaintenance".
    :type provisioning_state: str or ~azure.mgmt.healthcareapis.models.ProvisioningState
    :param authentication_configuration: Dicom Service authentication configuration.
    :type authentication_configuration:
     ~azure.mgmt.healthcareapis.models.DicomServiceAuthenticationConfiguration
    :ivar service_url: The url of the Dicom Services.
    :vartype service_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[a-z0-9][a-z0-9-]{1,21}[a-z0-9]$'},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'service_url': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'authentication_configuration': {'key': 'properties.authenticationConfiguration', 'type': 'DicomServiceAuthenticationConfiguration'},
        'service_url': {'key': 'properties.serviceUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DicomService, self).__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.authentication_configuration = kwargs.get('authentication_configuration', None)
        self.service_url = None


class DicomServiceAuthenticationConfiguration(msrest.serialization.Model):
    """Authentication configuration information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar authority: The authority url for the service.
    :vartype authority: str
    :ivar audiences: The audiences for the service.
    :vartype audiences: list[str]
    """

    _validation = {
        'authority': {'readonly': True},
        'audiences': {'readonly': True},
    }

    _attribute_map = {
        'authority': {'key': 'authority', 'type': 'str'},
        'audiences': {'key': 'audiences', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DicomServiceAuthenticationConfiguration, self).__init__(**kwargs)
        self.authority = None
        self.audiences = None


class DicomServiceCollection(msrest.serialization.Model):
    """The collection of Dicom Services.

    :param next_link: The link used to get the next page of Dicom Services.
    :type next_link: str
    :param value: The list of Dicom Services.
    :type value: list[~azure.mgmt.healthcareapis.models.DicomService]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DicomService]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DicomServiceCollection, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class DicomServicePatchResource(ResourceTags):
    """Dicom Service patch properties.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DicomServicePatchResource, self).__init__(**kwargs)


class Error(msrest.serialization.Model):
    """Error details.

    :param error: Error details.
    :type error: ~azure.mgmt.healthcareapis.models.ErrorDetailsInternal
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetailsInternal'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorDetails(msrest.serialization.Model):
    """Error details.

    :param error: Error details.
    :type error: ~azure.mgmt.healthcareapis.models.ErrorDetailsInternal
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetailsInternal'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorDetailsInternal(msrest.serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The target of the particular error.
    :vartype target: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetailsInternal, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None


class ServiceManagedIdentity(msrest.serialization.Model):
    """The managed identity of a service.

    :param identity: Setting indicating whether the service has a managed identity associated with
     it.
    :type identity: ~azure.mgmt.healthcareapis.models.ServiceManagedIdentityIdentity
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ServiceManagedIdentityIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceManagedIdentity, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)


class FhirService(TaggedResource, ServiceManagedIdentity):
    """The description of Fhir Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param identity: Setting indicating whether the service has a managed identity associated with
     it.
    :type identity: ~azure.mgmt.healthcareapis.models.ServiceManagedIdentityIdentity
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param etag: An etag associated with the resource, used for optimistic concurrency when editing
     it.
    :type etag: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: The kind of the service. Possible values include: "fhir-Stu3", "fhir-R4".
    :type kind: str or ~azure.mgmt.healthcareapis.models.FhirServiceKind
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthcareapis.models.SystemData
    :param provisioning_state: The provisioning state. Possible values include: "Deleting",
     "Succeeded", "Creating", "Accepted", "Verifying", "Updating", "Failed", "Canceled",
     "Deprovisioned", "Moving", "Suspended", "Warned", "SystemMaintenance".
    :type provisioning_state: str or ~azure.mgmt.healthcareapis.models.ProvisioningState
    :param access_policies: Fhir Service access policies.
    :type access_policies: list[~azure.mgmt.healthcareapis.models.FhirServiceAccessPolicyEntry]
    :param acr_configuration: Fhir Service Azure container registry configuration.
    :type acr_configuration: ~azure.mgmt.healthcareapis.models.FhirServiceAcrConfiguration
    :param authentication_configuration: Fhir Service authentication configuration.
    :type authentication_configuration:
     ~azure.mgmt.healthcareapis.models.FhirServiceAuthenticationConfiguration
    :param cors_configuration: Fhir Service Cors configuration.
    :type cors_configuration: ~azure.mgmt.healthcareapis.models.FhirServiceCorsConfiguration
    :param export_configuration: Fhir Service export configuration.
    :type export_configuration: ~azure.mgmt.healthcareapis.models.FhirServiceExportConfiguration
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[a-z0-9][a-z0-9-]{1,21}[a-z0-9]$'},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ServiceManagedIdentityIdentity'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'access_policies': {'key': 'properties.accessPolicies', 'type': '[FhirServiceAccessPolicyEntry]'},
        'acr_configuration': {'key': 'properties.acrConfiguration', 'type': 'FhirServiceAcrConfiguration'},
        'authentication_configuration': {'key': 'properties.authenticationConfiguration', 'type': 'FhirServiceAuthenticationConfiguration'},
        'cors_configuration': {'key': 'properties.corsConfiguration', 'type': 'FhirServiceCorsConfiguration'},
        'export_configuration': {'key': 'properties.exportConfiguration', 'type': 'FhirServiceExportConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FhirService, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.kind = kwargs.get('kind', None)
        self.system_data = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.access_policies = kwargs.get('access_policies', None)
        self.acr_configuration = kwargs.get('acr_configuration', None)
        self.authentication_configuration = kwargs.get('authentication_configuration', None)
        self.cors_configuration = kwargs.get('cors_configuration', None)
        self.export_configuration = kwargs.get('export_configuration', None)
        self.id = None
        self.name = None
        self.type = None
        self.etag = kwargs.get('etag', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.kind = kwargs.get('kind', None)
        self.system_data = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.access_policies = kwargs.get('access_policies', None)
        self.acr_configuration = kwargs.get('acr_configuration', None)
        self.authentication_configuration = kwargs.get('authentication_configuration', None)
        self.cors_configuration = kwargs.get('cors_configuration', None)
        self.export_configuration = kwargs.get('export_configuration', None)


class FhirServiceAccessPolicyEntry(msrest.serialization.Model):
    """An access policy entry.

    All required parameters must be populated in order to send to Azure.

    :param object_id: Required. An Azure AD object ID (User or Apps) that is allowed access to the
     FHIR service.
    :type object_id: str
    """

    _validation = {
        'object_id': {'required': True, 'pattern': r'^(([0-9A-Fa-f]{8}[-]?(?:[0-9A-Fa-f]{4}[-]?){3}[0-9A-Fa-f]{12}){1})+$'},
    }

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FhirServiceAccessPolicyEntry, self).__init__(**kwargs)
        self.object_id = kwargs['object_id']


class FhirServiceAcrConfiguration(msrest.serialization.Model):
    """Azure container registry configuration information.

    :param login_servers: The list of the Azure container registry login servers.
    :type login_servers: list[str]
    """

    _attribute_map = {
        'login_servers': {'key': 'loginServers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FhirServiceAcrConfiguration, self).__init__(**kwargs)
        self.login_servers = kwargs.get('login_servers', None)


class FhirServiceAuthenticationConfiguration(msrest.serialization.Model):
    """Authentication configuration information.

    :param authority: The authority url for the service.
    :type authority: str
    :param audience: The audience url for the service.
    :type audience: str
    :param smart_proxy_enabled: If the SMART on FHIR proxy is enabled.
    :type smart_proxy_enabled: bool
    """

    _attribute_map = {
        'authority': {'key': 'authority', 'type': 'str'},
        'audience': {'key': 'audience', 'type': 'str'},
        'smart_proxy_enabled': {'key': 'smartProxyEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FhirServiceAuthenticationConfiguration, self).__init__(**kwargs)
        self.authority = kwargs.get('authority', None)
        self.audience = kwargs.get('audience', None)
        self.smart_proxy_enabled = kwargs.get('smart_proxy_enabled', None)


class FhirServiceCollection(msrest.serialization.Model):
    """A collection of Fhir services.

    :param next_link: The link used to get the next page of Fhir Services.
    :type next_link: str
    :param value: The list of Fhir Services.
    :type value: list[~azure.mgmt.healthcareapis.models.FhirService]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[FhirService]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FhirServiceCollection, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class FhirServiceCorsConfiguration(msrest.serialization.Model):
    """The settings for the CORS configuration of the service instance.

    :param origins: The origins to be allowed via CORS.
    :type origins: list[str]
    :param headers: The headers to be allowed via CORS.
    :type headers: list[str]
    :param methods: The methods to be allowed via CORS.
    :type methods: list[str]
    :param max_age: The max age to be allowed via CORS.
    :type max_age: int
    :param allow_credentials: If credentials are allowed via CORS.
    :type allow_credentials: bool
    """

    _validation = {
        'max_age': {'maximum': 99999, 'minimum': 0},
    }

    _attribute_map = {
        'origins': {'key': 'origins', 'type': '[str]'},
        'headers': {'key': 'headers', 'type': '[str]'},
        'methods': {'key': 'methods', 'type': '[str]'},
        'max_age': {'key': 'maxAge', 'type': 'int'},
        'allow_credentials': {'key': 'allowCredentials', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FhirServiceCorsConfiguration, self).__init__(**kwargs)
        self.origins = kwargs.get('origins', None)
        self.headers = kwargs.get('headers', None)
        self.methods = kwargs.get('methods', None)
        self.max_age = kwargs.get('max_age', None)
        self.allow_credentials = kwargs.get('allow_credentials', None)


class FhirServiceExportConfiguration(msrest.serialization.Model):
    """Export operation configuration information.

    :param storage_account_name: The name of the default export storage account.
    :type storage_account_name: str
    """

    _attribute_map = {
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FhirServiceExportConfiguration, self).__init__(**kwargs)
        self.storage_account_name = kwargs.get('storage_account_name', None)


class FhirServicePatchResource(ResourceTags, ServiceManagedIdentity):
    """FhirService patch properties.

    :param identity: Setting indicating whether the service has a managed identity associated with
     it.
    :type identity: ~azure.mgmt.healthcareapis.models.ServiceManagedIdentityIdentity
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ServiceManagedIdentityIdentity'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FhirServicePatchResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.tags = kwargs.get('tags', None)


class IotConnector(TaggedResource, ServiceManagedIdentity):
    """IoT Connector definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param identity: Setting indicating whether the service has a managed identity associated with
     it.
    :type identity: ~azure.mgmt.healthcareapis.models.ServiceManagedIdentityIdentity
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param etag: An etag associated with the resource, used for optimistic concurrency when editing
     it.
    :type etag: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthcareapis.models.SystemData
    :param provisioning_state: The provisioning state. Possible values include: "Deleting",
     "Succeeded", "Creating", "Accepted", "Verifying", "Updating", "Failed", "Canceled",
     "Deprovisioned", "Moving", "Suspended", "Warned", "SystemMaintenance".
    :type provisioning_state: str or ~azure.mgmt.healthcareapis.models.ProvisioningState
    :param ingestion_endpoint_configuration: Source configuration.
    :type ingestion_endpoint_configuration:
     ~azure.mgmt.healthcareapis.models.IotEventHubIngestionEndpointConfiguration
    :param device_mapping: Device Mappings.
    :type device_mapping: ~azure.mgmt.healthcareapis.models.IotMappingProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[a-z0-9][a-z0-9-]{1,21}[a-z0-9]$'},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ServiceManagedIdentityIdentity'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'ingestion_endpoint_configuration': {'key': 'properties.ingestionEndpointConfiguration', 'type': 'IotEventHubIngestionEndpointConfiguration'},
        'device_mapping': {'key': 'properties.deviceMapping', 'type': 'IotMappingProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotConnector, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.system_data = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.ingestion_endpoint_configuration = kwargs.get('ingestion_endpoint_configuration', None)
        self.device_mapping = kwargs.get('device_mapping', None)
        self.id = None
        self.name = None
        self.type = None
        self.etag = kwargs.get('etag', None)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.system_data = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.ingestion_endpoint_configuration = kwargs.get('ingestion_endpoint_configuration', None)
        self.device_mapping = kwargs.get('device_mapping', None)


class IotConnectorCollection(msrest.serialization.Model):
    """A collection of IoT Connectors.

    :param next_link: The link used to get the next page of IoT Connectors.
    :type next_link: str
    :param value: The list of IoT Connectors.
    :type value: list[~azure.mgmt.healthcareapis.models.IotConnector]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[IotConnector]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotConnectorCollection, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class IotConnectorPatchResource(ResourceTags, ServiceManagedIdentity):
    """Iot Connector patch properties.

    :param identity: Setting indicating whether the service has a managed identity associated with
     it.
    :type identity: ~azure.mgmt.healthcareapis.models.ServiceManagedIdentityIdentity
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ServiceManagedIdentityIdentity'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotConnectorPatchResource, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.tags = kwargs.get('tags', None)


class IotDestinationProperties(msrest.serialization.Model):
    """Common IoT Connector destination properties.

    :param provisioning_state: The provisioning state. Possible values include: "Deleting",
     "Succeeded", "Creating", "Accepted", "Verifying", "Updating", "Failed", "Canceled",
     "Deprovisioned", "Moving", "Suspended", "Warned", "SystemMaintenance".
    :type provisioning_state: str or ~azure.mgmt.healthcareapis.models.ProvisioningState
    """

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotDestinationProperties, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)


class IotEventHubIngestionEndpointConfiguration(msrest.serialization.Model):
    """Event Hub ingestion endpoint configuration.

    :param event_hub_name: Event Hub name to connect to.
    :type event_hub_name: str
    :param consumer_group: Consumer group of the event hub to connected to.
    :type consumer_group: str
    :param fully_qualified_event_hub_namespace: Fully qualified namespace of the Event Hub to
     connect to.
    :type fully_qualified_event_hub_namespace: str
    """

    _attribute_map = {
        'event_hub_name': {'key': 'eventHubName', 'type': 'str'},
        'consumer_group': {'key': 'consumerGroup', 'type': 'str'},
        'fully_qualified_event_hub_namespace': {'key': 'fullyQualifiedEventHubNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotEventHubIngestionEndpointConfiguration, self).__init__(**kwargs)
        self.event_hub_name = kwargs.get('event_hub_name', None)
        self.consumer_group = kwargs.get('consumer_group', None)
        self.fully_qualified_event_hub_namespace = kwargs.get('fully_qualified_event_hub_namespace', None)


class IotFhirDestination(LocationBasedResource):
    """IoT Connector FHIR destination definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param etag: An etag associated with the resource, used for optimistic concurrency when editing
     it.
    :type etag: str
    :param location: The resource location.
    :type location: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthcareapis.models.SystemData
    :param provisioning_state: The provisioning state. Possible values include: "Deleting",
     "Succeeded", "Creating", "Accepted", "Verifying", "Updating", "Failed", "Canceled",
     "Deprovisioned", "Moving", "Suspended", "Warned", "SystemMaintenance".
    :type provisioning_state: str or ~azure.mgmt.healthcareapis.models.ProvisioningState
    :param resource_identity_resolution_type: Required. Determines how resource identity is
     resolved on the destination. Possible values include: "Create", "Lookup".
    :type resource_identity_resolution_type: str or
     ~azure.mgmt.healthcareapis.models.IotIdentityResolutionType
    :param fhir_service_resource_id: Required. Fully qualified resource id of the FHIR service to
     connect to.
    :type fhir_service_resource_id: str
    :param fhir_mapping: Required. FHIR Mappings.
    :type fhir_mapping: ~azure.mgmt.healthcareapis.models.IotMappingProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[a-z0-9][a-z0-9-]{1,21}[a-z0-9]$'},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'resource_identity_resolution_type': {'required': True},
        'fhir_service_resource_id': {'required': True},
        'fhir_mapping': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'resource_identity_resolution_type': {'key': 'properties.resourceIdentityResolutionType', 'type': 'str'},
        'fhir_service_resource_id': {'key': 'properties.fhirServiceResourceId', 'type': 'str'},
        'fhir_mapping': {'key': 'properties.fhirMapping', 'type': 'IotMappingProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotFhirDestination, self).__init__(**kwargs)
        self.system_data = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.resource_identity_resolution_type = kwargs['resource_identity_resolution_type']
        self.fhir_service_resource_id = kwargs['fhir_service_resource_id']
        self.fhir_mapping = kwargs['fhir_mapping']


class IotFhirDestinationCollection(msrest.serialization.Model):
    """A collection of IoT Connector FHIR destinations.

    :param next_link: The link used to get the next page of IoT FHIR destinations.
    :type next_link: str
    :param value: The list of IoT Connector FHIR destinations.
    :type value: list[~azure.mgmt.healthcareapis.models.IotFhirDestination]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[IotFhirDestination]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotFhirDestinationCollection, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class IotFhirDestinationProperties(IotDestinationProperties):
    """IoT Connector destination properties for an Azure FHIR service.

    All required parameters must be populated in order to send to Azure.

    :param provisioning_state: The provisioning state. Possible values include: "Deleting",
     "Succeeded", "Creating", "Accepted", "Verifying", "Updating", "Failed", "Canceled",
     "Deprovisioned", "Moving", "Suspended", "Warned", "SystemMaintenance".
    :type provisioning_state: str or ~azure.mgmt.healthcareapis.models.ProvisioningState
    :param resource_identity_resolution_type: Required. Determines how resource identity is
     resolved on the destination. Possible values include: "Create", "Lookup".
    :type resource_identity_resolution_type: str or
     ~azure.mgmt.healthcareapis.models.IotIdentityResolutionType
    :param fhir_service_resource_id: Required. Fully qualified resource id of the FHIR service to
     connect to.
    :type fhir_service_resource_id: str
    :param fhir_mapping: Required. FHIR Mappings.
    :type fhir_mapping: ~azure.mgmt.healthcareapis.models.IotMappingProperties
    """

    _validation = {
        'resource_identity_resolution_type': {'required': True},
        'fhir_service_resource_id': {'required': True},
        'fhir_mapping': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'resource_identity_resolution_type': {'key': 'resourceIdentityResolutionType', 'type': 'str'},
        'fhir_service_resource_id': {'key': 'fhirServiceResourceId', 'type': 'str'},
        'fhir_mapping': {'key': 'fhirMapping', 'type': 'IotMappingProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotFhirDestinationProperties, self).__init__(**kwargs)
        self.resource_identity_resolution_type = kwargs['resource_identity_resolution_type']
        self.fhir_service_resource_id = kwargs['fhir_service_resource_id']
        self.fhir_mapping = kwargs['fhir_mapping']


class IotMappingProperties(msrest.serialization.Model):
    """The mapping content.

    :param content: The mapping.
    :type content: any
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IotMappingProperties, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)


class ListOperations(msrest.serialization.Model):
    """Available operations of the service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of available operation details.
    :vartype value: list[~azure.mgmt.healthcareapis.models.OperationDetail]
    :param next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationDetail]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListOperations, self).__init__(**kwargs)
        self.value = None
        self.next_link = kwargs.get('next_link', None)


class OperationDetail(msrest.serialization.Model):
    """Service REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :param display: Display of the operation.
    :type display: ~azure.mgmt.healthcareapis.models.OperationDisplay
    :ivar origin: Default value is 'user,system'.
    :vartype origin: str
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Possible values include: "Internal".
    :vartype action_type: str or ~azure.mgmt.healthcareapis.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDetail, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = kwargs.get('display', None)
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.HealthcareApis.
    :vartype provider: str
    :ivar resource: Resource Type: Services.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Friendly description for the operation,.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationResultsDescription(msrest.serialization.Model):
    """The properties indicating the operation result of an operation on a service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the operation returned.
    :vartype id: str
    :ivar name: The name of the operation result.
    :vartype name: str
    :ivar status: The status of the operation being performed. Possible values include: "Canceled",
     "Succeeded", "Failed", "Requested", "Running".
    :vartype status: str or ~azure.mgmt.healthcareapis.models.OperationResultStatus
    :ivar start_time: The time that the operation was started.
    :vartype start_time: str
    :param properties: Additional properties of the operation result.
    :type properties: any
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationResultsDescription, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.status = None
        self.start_time = None
        self.properties = kwargs.get('properties', None)


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~azure.mgmt.healthcareapis.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.healthcareapis.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.healthcareapis.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateEndpointConnectionDescription(PrivateEndpointConnection):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~azure.mgmt.healthcareapis.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.healthcareapis.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.healthcareapis.models.PrivateEndpointConnectionProvisioningState
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthcareapis.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionDescription, self).__init__(**kwargs)
        self.system_data = None


class PrivateEndpointConnectionListResultDescription(msrest.serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :param value: Array of private endpoint connections.
    :type value: list[~azure.mgmt.healthcareapis.models.PrivateEndpointConnectionDescription]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnectionDescription]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResultDescription, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = kwargs.get('required_zone_names', None)


class PrivateLinkResourceDescription(PrivateLinkResource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthcareapis.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceDescription, self).__init__(**kwargs)
        self.system_data = None


class PrivateLinkResourceListResultDescription(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private link resources.
    :type value: list[~azure.mgmt.healthcareapis.models.PrivateLinkResourceDescription]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResourceDescription]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResultDescription, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected".
    :type status: str or ~azure.mgmt.healthcareapis.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class ServiceAccessPolicyEntry(msrest.serialization.Model):
    """An access policy entry.

    All required parameters must be populated in order to send to Azure.

    :param object_id: Required. An Azure AD object ID (User or Apps) that is allowed access to the
     FHIR service.
    :type object_id: str
    """

    _validation = {
        'object_id': {'required': True, 'pattern': r'^(([0-9A-Fa-f]{8}[-]?(?:[0-9A-Fa-f]{4}[-]?){3}[0-9A-Fa-f]{12}){1})+$'},
    }

    _attribute_map = {
        'object_id': {'key': 'objectId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceAccessPolicyEntry, self).__init__(**kwargs)
        self.object_id = kwargs['object_id']


class ServiceAcrConfigurationInfo(msrest.serialization.Model):
    """Azure container registry configuration information.

    :param login_servers: The list of the ACR login servers.
    :type login_servers: list[str]
    """

    _attribute_map = {
        'login_servers': {'key': 'loginServers', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceAcrConfigurationInfo, self).__init__(**kwargs)
        self.login_servers = kwargs.get('login_servers', None)


class ServiceAuthenticationConfigurationInfo(msrest.serialization.Model):
    """Authentication configuration information.

    :param authority: The authority url for the service.
    :type authority: str
    :param audience: The audience url for the service.
    :type audience: str
    :param smart_proxy_enabled: If the SMART on FHIR proxy is enabled.
    :type smart_proxy_enabled: bool
    """

    _attribute_map = {
        'authority': {'key': 'authority', 'type': 'str'},
        'audience': {'key': 'audience', 'type': 'str'},
        'smart_proxy_enabled': {'key': 'smartProxyEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceAuthenticationConfigurationInfo, self).__init__(**kwargs)
        self.authority = kwargs.get('authority', None)
        self.audience = kwargs.get('audience', None)
        self.smart_proxy_enabled = kwargs.get('smart_proxy_enabled', None)


class ServiceCorsConfigurationInfo(msrest.serialization.Model):
    """The settings for the CORS configuration of the service instance.

    :param origins: The origins to be allowed via CORS.
    :type origins: list[str]
    :param headers: The headers to be allowed via CORS.
    :type headers: list[str]
    :param methods: The methods to be allowed via CORS.
    :type methods: list[str]
    :param max_age: The max age to be allowed via CORS.
    :type max_age: int
    :param allow_credentials: If credentials are allowed via CORS.
    :type allow_credentials: bool
    """

    _validation = {
        'max_age': {'maximum': 99999, 'minimum': 0},
    }

    _attribute_map = {
        'origins': {'key': 'origins', 'type': '[str]'},
        'headers': {'key': 'headers', 'type': '[str]'},
        'methods': {'key': 'methods', 'type': '[str]'},
        'max_age': {'key': 'maxAge', 'type': 'int'},
        'allow_credentials': {'key': 'allowCredentials', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceCorsConfigurationInfo, self).__init__(**kwargs)
        self.origins = kwargs.get('origins', None)
        self.headers = kwargs.get('headers', None)
        self.methods = kwargs.get('methods', None)
        self.max_age = kwargs.get('max_age', None)
        self.allow_credentials = kwargs.get('allow_credentials', None)


class ServiceCosmosDbConfigurationInfo(msrest.serialization.Model):
    """The settings for the Cosmos DB database backing the service.

    :param offer_throughput: The provisioned throughput for the backing database.
    :type offer_throughput: int
    :param key_vault_key_uri: The URI of the customer-managed key for the backing database.
    :type key_vault_key_uri: str
    """

    _validation = {
        'offer_throughput': {'maximum': 10000, 'minimum': 400},
    }

    _attribute_map = {
        'offer_throughput': {'key': 'offerThroughput', 'type': 'int'},
        'key_vault_key_uri': {'key': 'keyVaultKeyUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceCosmosDbConfigurationInfo, self).__init__(**kwargs)
        self.offer_throughput = kwargs.get('offer_throughput', None)
        self.key_vault_key_uri = kwargs.get('key_vault_key_uri', None)


class ServiceExportConfigurationInfo(msrest.serialization.Model):
    """Export operation configuration information.

    :param storage_account_name: The name of the default export storage account.
    :type storage_account_name: str
    """

    _attribute_map = {
        'storage_account_name': {'key': 'storageAccountName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceExportConfigurationInfo, self).__init__(**kwargs)
        self.storage_account_name = kwargs.get('storage_account_name', None)


class ServiceManagedIdentityIdentity(msrest.serialization.Model):
    """Setting indicating whether the service has a managed identity associated with it.

    :param type: Type of identity being specified, currently SystemAssigned and None are allowed.
     Possible values include: "SystemAssigned", "None".
    :type type: str or ~azure.mgmt.healthcareapis.models.ManagedServiceIdentityType
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceManagedIdentityIdentity, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)


class ServicesResource(msrest.serialization.Model):
    """The common properties of a service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param kind: Required. The kind of the service. Possible values include: "fhir", "fhir-Stu3",
     "fhir-R4".
    :type kind: str or ~azure.mgmt.healthcareapis.models.Kind
    :param location: Required. The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param etag: An etag associated with the resource, used for optimistic concurrency when editing
     it.
    :type etag: str
    :param identity: Setting indicating whether the service has a managed identity associated with
     it.
    :type identity: ~azure.mgmt.healthcareapis.models.ServicesResourceIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[a-z0-9][a-z0-9-]{1,21}[a-z0-9]$'},
        'type': {'readonly': True},
        'kind': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ServicesResourceIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicesResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kind = kwargs['kind']
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.etag = kwargs.get('etag', None)
        self.identity = kwargs.get('identity', None)


class ServicesDescription(ServicesResource):
    """The description of the service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param kind: Required. The kind of the service. Possible values include: "fhir", "fhir-Stu3",
     "fhir-R4".
    :type kind: str or ~azure.mgmt.healthcareapis.models.Kind
    :param location: Required. The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param etag: An etag associated with the resource, used for optimistic concurrency when editing
     it.
    :type etag: str
    :param identity: Setting indicating whether the service has a managed identity associated with
     it.
    :type identity: ~azure.mgmt.healthcareapis.models.ServicesResourceIdentity
    :param properties: The common properties of a service.
    :type properties: ~azure.mgmt.healthcareapis.models.ServicesProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthcareapis.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[a-z0-9][a-z0-9-]{1,21}[a-z0-9]$'},
        'type': {'readonly': True},
        'kind': {'required': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ServicesResourceIdentity'},
        'properties': {'key': 'properties', 'type': 'ServicesProperties'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicesDescription, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.system_data = None


class ServicesDescriptionListResult(msrest.serialization.Model):
    """A list of service description objects with a next link.

    :param next_link: The link used to get the next page of service description objects.
    :type next_link: str
    :param value: A list of service description objects.
    :type value: list[~azure.mgmt.healthcareapis.models.ServicesDescription]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ServicesDescription]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicesDescriptionListResult, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ServicesNameAvailabilityInfo(msrest.serialization.Model):
    """The properties indicating whether a given service name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: The value which indicates whether the provided name is available.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability. Possible values include: "Invalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.healthcareapis.models.ServiceNameUnavailabilityReason
    :param message: The detailed reason message.
    :type message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicesNameAvailabilityInfo, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = kwargs.get('message', None)


class ServicesPatchDescription(msrest.serialization.Model):
    """The description of the service.

    :param tags: A set of tags. Instance tags.
    :type tags: dict[str, str]
    :param public_network_access: Control permission for data plane traffic coming from public
     networks while private endpoint is enabled. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.healthcareapis.models.PublicNetworkAccess
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicesPatchDescription, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.public_network_access = kwargs.get('public_network_access', None)


class ServicesProperties(msrest.serialization.Model):
    """The properties of a service instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state. Possible values include: "Deleting",
     "Succeeded", "Creating", "Accepted", "Verifying", "Updating", "Failed", "Canceled",
     "Deprovisioned", "Moving", "Suspended", "Warned", "SystemMaintenance".
    :vartype provisioning_state: str or ~azure.mgmt.healthcareapis.models.ProvisioningState
    :param access_policies: The access policies of the service instance.
    :type access_policies: list[~azure.mgmt.healthcareapis.models.ServiceAccessPolicyEntry]
    :param cosmos_db_configuration: The settings for the Cosmos DB database backing the service.
    :type cosmos_db_configuration:
     ~azure.mgmt.healthcareapis.models.ServiceCosmosDbConfigurationInfo
    :param authentication_configuration: The authentication configuration for the service instance.
    :type authentication_configuration:
     ~azure.mgmt.healthcareapis.models.ServiceAuthenticationConfigurationInfo
    :param cors_configuration: The settings for the CORS configuration of the service instance.
    :type cors_configuration: ~azure.mgmt.healthcareapis.models.ServiceCorsConfigurationInfo
    :param export_configuration: The settings for the export operation of the service instance.
    :type export_configuration: ~azure.mgmt.healthcareapis.models.ServiceExportConfigurationInfo
    :param private_endpoint_connections: The list of private endpoint connections that are set up
     for this resource.
    :type private_endpoint_connections:
     list[~azure.mgmt.healthcareapis.models.PrivateEndpointConnection]
    :param public_network_access: Control permission for data plane traffic coming from public
     networks while private endpoint is enabled. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.healthcareapis.models.PublicNetworkAccess
    :param acr_configuration: The azure container registry settings used for convert data operation
     of the service instance.
    :type acr_configuration: ~azure.mgmt.healthcareapis.models.ServiceAcrConfigurationInfo
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'access_policies': {'key': 'accessPolicies', 'type': '[ServiceAccessPolicyEntry]'},
        'cosmos_db_configuration': {'key': 'cosmosDbConfiguration', 'type': 'ServiceCosmosDbConfigurationInfo'},
        'authentication_configuration': {'key': 'authenticationConfiguration', 'type': 'ServiceAuthenticationConfigurationInfo'},
        'cors_configuration': {'key': 'corsConfiguration', 'type': 'ServiceCorsConfigurationInfo'},
        'export_configuration': {'key': 'exportConfiguration', 'type': 'ServiceExportConfigurationInfo'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'acr_configuration': {'key': 'acrConfiguration', 'type': 'ServiceAcrConfigurationInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicesProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.access_policies = kwargs.get('access_policies', None)
        self.cosmos_db_configuration = kwargs.get('cosmos_db_configuration', None)
        self.authentication_configuration = kwargs.get('authentication_configuration', None)
        self.cors_configuration = kwargs.get('cors_configuration', None)
        self.export_configuration = kwargs.get('export_configuration', None)
        self.private_endpoint_connections = kwargs.get('private_endpoint_connections', None)
        self.public_network_access = kwargs.get('public_network_access', None)
        self.acr_configuration = kwargs.get('acr_configuration', None)


class ServicesResourceIdentity(msrest.serialization.Model):
    """Setting indicating whether the service has a managed identity associated with it.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the resource.
    :vartype tenant_id: str
    :param type: Type of identity being specified, currently SystemAssigned and None are allowed.
     Possible values include: "SystemAssigned", "None".
    :type type: str or ~azure.mgmt.healthcareapis.models.ManagedServiceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicesResourceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.healthcareapis.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.healthcareapis.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class Workspace(TaggedResource):
    """Workspace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param etag: An etag associated with the resource, used for optimistic concurrency when editing
     it.
    :type etag: str
    :param location: The resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param properties: Workspaces resource specific properties.
    :type properties: ~azure.mgmt.healthcareapis.models.WorkspaceProperties
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.healthcareapis.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^[a-z0-9][a-z0-9-]{1,21}[a-z0-9]$'},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'WorkspaceProperties'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Workspace, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)
        self.system_data = None


class WorkspaceList(msrest.serialization.Model):
    """Collection of workspace object with a next link.

    :param next_link: The link used to get the next page.
    :type next_link: str
    :param value: Collection of resources.
    :type value: list[~azure.mgmt.healthcareapis.models.Workspace]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Workspace]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class WorkspacePatchResource(ResourceTags):
    """Workspace patch properties.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspacePatchResource, self).__init__(**kwargs)


class WorkspaceProperties(msrest.serialization.Model):
    """Workspaces resource specific properties.

    :param provisioning_state: The provisioning state. Possible values include: "Deleting",
     "Succeeded", "Creating", "Accepted", "Verifying", "Updating", "Failed", "Canceled",
     "Deprovisioned", "Moving", "Suspended", "Warned", "SystemMaintenance".
    :type provisioning_state: str or ~azure.mgmt.healthcareapis.models.ProvisioningState
    """

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceProperties, self).__init__(**kwargs)
        self.provisioning_state = kwargs.get('provisioning_state', None)
