# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AnalyzeResultOperationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Operation status.
    """

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    FAILED = "failed"
    SUCCEEDED = "succeeded"

class ApiVersion(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """API version.
    """

    TWO_THOUSAND_TWENTY_ONE09_30_PREVIEW = "2021-09-30-preview"

class ContentType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Content type for upload
    """

    #: Content Type 'application/octet-stream'.
    APPLICATION_OCTET_STREAM = "application/octet-stream"
    #: Content Type 'application/pdf'.
    APPLICATION_PDF = "application/pdf"
    #: Content Type 'image/bmp'.
    IMAGE_BMP = "image/bmp"
    #: Content Type 'image/jpeg'.
    IMAGE_JPEG = "image/jpeg"
    #: Content Type 'image/png'.
    IMAGE_PNG = "image/png"
    #: Content Type 'image/tiff'.
    IMAGE_TIFF = "image/tiff"

class DocumentFieldType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Semantic data type of the field value.
    """

    STRING = "string"
    DATE = "date"
    TIME = "time"
    PHONE_NUMBER = "phoneNumber"
    NUMBER = "number"
    INTEGER = "integer"
    SELECTION_MARK = "selectionMark"
    COUNTRY_REGION = "countryRegion"
    SIGNATURE = "signature"
    ARRAY = "array"
    OBJECT = "object"

class DocumentSignatureType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Presence of signature.
    """

    SIGNED = "signed"
    UNSIGNED = "unsigned"

class DocumentTableCellKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Table cell kind.
    """

    CONTENT = "content"
    ROW_HEADER = "rowHeader"
    COLUMN_HEADER = "columnHeader"
    STUB_HEAD = "stubHead"
    DESCRIPTION = "description"

class LengthUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The unit used by the width, height, and boundingBox properties. For images, the unit is
    "pixel". For PDF, the unit is "inch".
    """

    PIXEL = "pixel"
    INCH = "inch"

class OperationKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of operation.
    """

    DOCUMENT_MODEL_BUILD = "documentModelBuild"
    DOCUMENT_MODEL_COMPOSE = "documentModelCompose"
    DOCUMENT_MODEL_COPY_TO = "documentModelCopyTo"

class OperationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Operation status.
    """

    NOT_STARTED = "notStarted"
    RUNNING = "running"
    FAILED = "failed"
    SUCCEEDED = "succeeded"
    CANCELED = "canceled"

class SelectionMarkState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """State of the selection mark.
    """

    SELECTED = "selected"
    UNSELECTED = "unselected"

class StringIndexType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Method used to compute string offset and length.
    """

    TEXT_ELEMENTS = "textElements"
    UNICODE_CODE_POINT = "unicodeCodePoint"
    UTF16_CODE_UNIT = "utf16CodeUnit"
