# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource_py3 import ProxyResource


class DataSource(ProxyResource):
    """Datasources under OMS Workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param tags: Resource tags
    :type tags: dict[str, str]
    :param properties: Required. The data source properties in raw json
     format, each kind of data source have it's own schema.
    :type properties: object
    :param e_tag: The ETag of the data source.
    :type e_tag: str
    :param kind: Required. Possible values include: 'AzureActivityLog',
     'ChangeTrackingPath', 'ChangeTrackingDefaultPath',
     'ChangeTrackingDefaultRegistry', 'ChangeTrackingCustomRegistry',
     'CustomLog', 'CustomLogCollection', 'GenericDataSource', 'IISLogs',
     'LinuxPerformanceObject', 'LinuxPerformanceCollection', 'LinuxSyslog',
     'LinuxSyslogCollection', 'WindowsEvent', 'WindowsPerformanceCounter'
    :type kind: str or ~azure.mgmt.loganalytics.models.DataSourceKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'object'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, *, properties, kind, tags=None, e_tag: str=None, **kwargs) -> None:
        super(DataSource, self).__init__(tags=tags, **kwargs)
        self.properties = properties
        self.e_tag = e_tag
        self.kind = kind
