# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ClientDiscoveryValueForSingleApi(Model):
    """Available operation details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar display: Contains the localized display information for this
     particular operation.
    :vartype display: :class:`ClientDiscoveryDisplay
     <azure.mgmt.recoveryservices.models.ClientDiscoveryDisplay>`
    :ivar origin: The intended executor of the operation.
    :vartype origin: str
    :ivar service_specification: Operation properties.
    :vartype service_specification:
     :class:`ClientDiscoveryForServiceSpecification
     <azure.mgmt.recoveryservices.models.ClientDiscoveryForServiceSpecification>`
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'service_specification': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'display': {'key': 'Display', 'type': 'ClientDiscoveryDisplay'},
        'origin': {'key': 'Origin', 'type': 'str'},
        'service_specification': {'key': 'Properties.serviceSpecification', 'type': 'ClientDiscoveryForServiceSpecification'},
    }

    def __init__(self):
        self.name = None
        self.display = None
        self.origin = None
        self.service_specification = None
