/*
 * AllFileFilter.java - 0.9.0     01/07/2001 - 12:30:24
 *
 * Copyright (C) 2001,,2003 2002 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
 
 
package net.sourceforge.groboutils.util.io.v1;
 
import java.io.IOException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;



/**
 * Allows all files to be accepted.
 *
 * @author   Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since    January 7, 2001
 * @version  $Date: 2003/02/10 22:52:45 $
 */
public class AllFileFilter extends AllFilenameFilter implements FileFilter
{
    /**
     * Default constructor.
     */
    public AllFileFilter()
    {
        // do nothing
    }
    
    /**
     * Accepts all files.
     */
    public boolean accept( File pathname )
    {
        return true;
    }
    
    
    /**
     * Accepts all files.
     */
    public boolean accept( File dir, String name )
    {
        return true;
    }
}
