# README.md - pyani/tests

This README describes the `pyani` testing suite

## Testing `pyani`

### Dependencies

The tests in this directory rely on the [`nose`](https://nose.readthedocs.org/en/latest/) package, which can be installed using

```
pip install nose
```

### Running tests

To run the tests in this directory with `nose` run the following command:

```
nosetests
```

This will run silently for quite a while (the comparisons are not quick), but should generate output that looks like this:

```
$ nosetests
........
Thread 2: value 0
Thread 2: value 1
Thread 3: value 0
Thread 3: value 1
Thread 3: value 2
Thread 1: value 0
Thread 4: value 0
Thread 4: value 1
Thread 4: value 2
Thread 4: value 3
..
----------------------------------------------------------------------
Ran 14 tests in 804.833s

OK
```


## The tests

### `test_cmdlines.py`

This tests the correct generation of `nucmer` command lines by the `anim.py` module.

### `test_concordance.py`

This tests the results of ANIm, ANIb, ANIblastall and TETRA analysis (using the relevant modules, not the `average_nucleotide_identity.py` script) against the corresponding results from the [`JSpecies`](http://imedea.uib-csic.es/jspecies/) package. The `JSpecies` output has previously been collected and is described in `test_JSpecies/README.md`.

### `test_dependencies.py`

Tests whether `pyani`'s dependencies are installed.

### `test_multiprocessing.py`

Tests correct functioning of the `run_multiprocessing` module.

### `test_parsing.py`

Tests correct parsing of `nucmer` `.delta` files by `anim`.


## Other files

Four directories contain reference tabular output files, to check consistency of analysis output on the test data in `test_ani_data`:

* `target_ANIb_output/`
* `target_ANIblastall_output/`
* `target_ANIm_output/`
* `target_TETRA_output/`

The `test_ani_data` directory contains input files for testing `pyani`, and examples for comparative testing of graphics output.

The `test_failing_data` directory contains input data that throws expected errors in ANI analysis, as described in `test_failing_data/README.md`.