
/*
** Copyright 1992
** Patrick Sweeney
*/
#include <stdio.h>
#include "ll2.h"

Ll2 *
 ll2_create()
{
    Ll2 *l;

    if ((l = (Ll2 *) malloc(sizeof(Ll2))) == NULL)
	return NULL;
    l->first = l->last = NULL;
    return l;
}

void ll2_destroy(Ll2 * ll2, void (*destroyfunc) (char *data))
{
    Ll2e *e, *ne;

    if (ll2) {
	e = ll2->first;
	while (e) {
	    if (e->data)
		(*destroyfunc) (e->data);
	    ne = e->next;
	    free((char *) e);
	    e = ne;
	}
    }
    return;
}

int ll2_append(Ll2 * ll2, char *data)
{
    Ll2e *e;

    if ((e = (Ll2e *) malloc(sizeof(Ll2e))) == NULL)
	return -1;
    e->prev = ll2->last;
    e->next = NULL;
    e->data = data;
    if (ll2->last)
	ll2->last->next = e;
    else
	ll2->first = e;
    ll2->last = e;
    return 0;
}
