static char SCCSID[] = "@(#)rects.c	1.2 89/02/22";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"

static GC drawWhite, drawBlack;
static XRectangle *rectangles;
#define NRECT   64

/*
 * rectangles
 *
 * often called for boxes/labels/rubbering
 */
rects_setup(dpy, win, len)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);
	int i;
	XRectangle *rp;

	drawWhite = XCreateGC(dpy, win, 0L, NULL);
	if (! drawWhite) return 1;
	XSetForeground(dpy, drawWhite, WhitePixel(dpy, screen));
	XSetBackground(dpy, drawWhite, BlackPixel(dpy, screen));

	drawBlack = XCreateGC(dpy, win, 0L, NULL);
	if (!drawBlack) return 1;
	XSetForeground(dpy, drawBlack, BlackPixel(dpy, screen));
	XSetBackground(dpy, drawBlack, WhitePixel(dpy, screen));

	rectangles = (XRectangle *)malloc(sizeof(XRectangle) * NRECT);
	if (rectangles == (XRectangle *)0)
	    return 1;

	rp = rectangles;
	for (i=0; i<NRECT; i++) {
	    rp->x = i; rp->y = i;
	    rp->width = len; rp->height = len;
	    rp++;
	}
	return 0;
}

rects_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, drawWhite);
	XFreeGC(dpy, drawBlack);
	free(rectangles);
}

rects_bench(dpy, win, len)
Display *dpy;
Window win;
{
	int nrects;

	nrects = 0;
	while (benchRunning) {
	    XDrawRectangles(dpy, win, drawWhite, rectangles, NRECT);
	    XDrawRectangles(dpy, win, drawBlack, rectangles, NRECT);
	    nrects += 2*NRECT;
	}
	return nrects;
}

rects_msg(deltaT, nrects, len, rate)
double rate;
{
	printf("RECTANGLES\n");
	printf("\n");
	printf("%d rectangles with %d pixel sides in %d secs\n",
				nrects, len, deltaT);
	printf("rate = %8.2f rectangles/sec (%d Pixels/sec)\n",
				rate, (nrects*4*len)/deltaT);
}
