static char SCCSID[] = "@(#)imagestr.c	1.1 89/02/08";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"

static GC myGC;
static XFontStruct *fontinfo;
static int fontHeight, fontAscent;

/*
 * draw image strings in different fixed fonts
 *
 * almost everywhere used esp. in terminal emulators
 */
imagestring_setup(dpy, win, fontName)
Display *dpy;
Window win;
char *fontName;
{
	int screen = DefaultScreen(dpy);

	fontinfo = XLoadQueryFont(dpy, fontName);
	if (fontinfo == NULL) {
	    printf("FONT %s NOT AVAILABLE - BENCHMARK NOT POSSIBLE\n", fontName);
	    return 1;
	}

	myGC = XCreateGC(dpy, win, 0L, NULL);
	if (!myGC) return 1;

	XSetForeground(dpy, myGC, WhitePixel(dpy, screen));
	XSetBackground(dpy, myGC, BlackPixel(dpy, screen));
	XSetFont(dpy, myGC, fontinfo->fid);

	fontAscent = fontinfo->max_bounds.ascent;
	fontHeight = fontAscent + fontinfo->max_bounds.descent;
	return 0;
}

imagestring_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeFont(dpy, fontinfo);
	XFreeGC(dpy, myGC);
}

imagestring_bench(dpy, win, dummy)
Display *dpy;
Window win;
{
	int y;
	int nstrings;
	char *theString = "123456789012345678901234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	int len;

	len = strlen(theString);
	y = fontAscent;
	nstrings = 0;
	while (benchRunning) {
	    XDrawImageString(dpy, win, myGC, 0, y, theString, len);
	    y = (y + 1) & 0xFF;
	    if (y == 0) {
		y = fontAscent;
	    }
	    nstrings++;
	}
	return (nstrings * len);
}

imagestring_msg(deltaT, nchars, fontName, rate)
char *fontName;
double rate;
{
	printf("DRAW IMAGE STRING - font=\"%s\" (height = %d)\n", fontName, fontHeight);
	printf("\n");
	printf("%d chars in %d secs\n", nchars, deltaT);
	printf("rate = %8.2f chars/sec\n", rate);
}
