# a.tcl --
# floppy disk installer

proc Floppy {} {
    Platform_Install /home/bwelch/src/webtk /floppy/floppy0
}
proc Win {} {
    Platform_Install a:/ c:/src/webtk
}
proc Mac {} {
    Platform_Install /webtk /MacServer/Brent/dist
}
# Install from the floppy (written on UNIX) to the hard drive
proc Platform_Install {{src webtk:} {dest MacServer:Brent:}} {
    set save [pwd]
    cd $src
    foreach f [glob README* license* LICENSE*] {
	File_Copy $f $dest
    }
    foreach dir {bin html lib images user} \
	    pat {{webtk.tcl} {form template *.html *.HTML *.htm *.HTM } {*.tcl *.TCL *.app *.APP tclIndex}  {*.gif *.GIF *.xbm *.XBM} {*}} {
	cd [file join $src $dir]
	set dir [file join $dest $dir]
	if ![file isdirectory $dir] {
	    catch {file mkdir $dir}
	}
	if ![file isdirectory $dir] {
	    puts "$dir doesn't exist"
	    continue
	}
	puts $dir ; update idletasks
	foreach f [lsort [eval glob -nocomplain $pat]] {
	    regsub -nocase {.htm$} $f {.html} newf
	    set newf [string tolower $newf]
	    if {[string compare $newf "macintos.tcl"] == 0} {
		set newf macintosh.tcl
	    }
	    if {[string tolower [file extension $newf]] == ".gif"} {
		File_CopyBin $f [file join $dir $newf]
	    } else {
		File_Copy $f [file join $dir $newf]
	    }
	}
    }
    cd $save
}
# Copy a file
proc File_Copy {src dest} {
    global FileCopyDest
    if [file isdirectory $src] {
	if ![file exists $dest] {
	    if {[catch {file mkdir $dest}] && [catch {mkdir $dest}] &&
		[catch {exec mkdir $dest}]} {
		error "Cannot create directory $dest"
	    }
	}
	foreach f [glob -nocomplain [file join $src *]] {
	    File_Copy $f [file join $dest [file tail $f]]
	}
	return
    }
    set in [open $src]
    if [file isdirectory $dest] {
	set dest [file join $dest [file tail $src]]
    }
    set FileCopyDest $dest	;# For GUI
    puts $dest
    update idletasks
    set out [open $dest w]
    puts $out [read $in]
    close $out
    close $in
}
# Copy a file
catch {rename unsupported0 copychannel}

proc File_CopyBin {src dest} {
    global FileCopyDest
    set in [open $src]
    fconfigure $in -trans binary
    if [file isdirectory $dest] {
	set dest [file join $dest [file tail $src]]
    }
    puts "$dest (binary)"; update idletasks
    set FileCopyDest $dest	;# For GUI
    set out [open $dest w]
    fconfigure $out -trans binary
    copychannel $in $out
    close $out
    close $in
}
