/**
*
* Structure to hold information about math exceptions
*
*/
struct exception 
	{
	int type;		/* error type */
	char *name;		/* math function name */
	double arg1, arg2; 	/* function arguments */
	double retval;		/* proposed return value */
	};

/*
*
* Exception type codes, found in exception.type
*
*/
#define DOMAIN    1	/* domain error */
#define SING      2	/* singularity */
#define OVERFLOW  3	/* overflow */
#define UNDERFLOW 4	/* underflow */
#define TLOSS	  5	/* total loss of significance */
#define PLOSS	  6	/* partial loss of significance */

/**
*
* Error codes generated by basic arithmetic operations (+ - * /)
*
*/
#define FPEUND 1	/* underflow */
#define FPEOVF 2	/* overflow */
#define FPEZDV 3	/* zero divisor */
#define FPENAN 4	/* not a number (invalid operation) */
#define FPECOM 5	/* not comparable */
 
/**
*
* Constants 
*
*/
#define PI   3.14159265358979323846
#define PID2 1.57079632679489661923	/* PI divided by 2 */
#define PID4 0.78539816339744830962	/* PI divided by 4 */
#define I_PI 0.31830988618379067154	/* Inverse of PI */
#define I_PID2 0.63661977236758134308	/* Inverse of PID2 */
 
#define HUGE 1.797693e308		/* huge value */
#define TINY 2.2e-308			/* tiny value */
#define LOGHUGE 709.778			/* natural log of huge value */
#define LOGTINY -708.396		/* natural log of tiny value */

/**
*
* External declarations
*
*/
extern int _FPERR;	/* floating point arithmetic error */
extern int errno;	/* UNIX error code */

#ifndef NARGS
extern double acos(double);
extern double asin(double);
extern double atan(double);
extern double atan2(double, double);
extern double atof(char *);
extern double ceil(double);
extern double cos(double);
extern double cosh(double);
extern void CXFERR(int);
extern double drand48(void); 
extern char *ecvt(double, int, int *, int *);
extern double erand48(short *);
extern double except(int, char *, double, double, double);
extern double exp(double);
extern double fabs(double);
extern char *fcvt(double, int, int *, int *);
extern double floor(double);
extern double fmod(double, double);
extern double frexp(double, int *);
extern char *gcvt(double, int, char *);
extern long jrand48(short *);
extern double ldexp(double, int);
extern void lcong48(short *);
extern double log(double);
extern double log10(double);
extern long lrand48(void);
extern int matherr(struct exception *);
extern double modf(double, double *);
extern long mrand48(void);
extern long nrand48(short *);
extern double pow(double, double);
extern int rand(void);
extern short *seed48(short *);
extern double sin(double);
extern double sinh(double);
extern double sqrt(double);
extern void srand(unsigned);
extern void srand48(long);
extern double tan(double);
extern double tanh(double);

#else
extern double acos();
extern double asin();
extern double atan();
extern double atan2();
extern double atof();
extern double ceil();
extern double cos();
extern double cosh();
extern void CXFERR();
extern double drand48(); 
extern char *ecvt();
extern double erand48();
extern double except();
extern double exp();
extern double fabs();
extern char *fcvt();
extern double floor();
extern double fmod();
extern double frexp();
extern char *gcvt();
extern long jrand48();
extern void lcong48();
extern double ldexp();
extern double log();
extern double log10();
extern long lrand48();
extern int matherr();
extern double modf();
extern long mrand48();
extern long nrand48();
extern double pow();
extern int rand();
extern short *seed48();
extern double sin();
extern double sinh();
extern double sqrt();
extern void srand();
extern void srand48();
extern double tan();
extern double tanh();
#endif

/**
*
* Macros
*
*/
#define abs(x) ((x)<0?-(x):(x))
#define max(a,b) ((a)>(b)?(a):(b))
#define min(a,b) ((a)<=(b)?(a):(b))

/**
*
* Define NULL if it's not already defined
*
*/
#ifndef NULL
#if SPTR
#define NULL 0			/* null pointer value */
#else
#define NULL 0L
#endif
#endif

