#| -*-Scheme-*-

$Header: vmsunp.scm,v 14.3 89/10/26 06:47:34 GMT cph Rel $

Copyright (c) 1988, 1989 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Pathname Unparsing -- VMS
;;; package: (runtime pathname-unparser)

(declare (usual-integrations))

(define (pathname-unparse host device directory name type version)
  (string-append (let ((host-string (unparse-component host)))
		   (if host-string
		       (string-append host-string "::")
		       ""))
		 (let ((device-string (unparse-component device)))
		   (if device-string
		       (string-append device-string ":")
		       ""))
		 (unparse-directory directory)
		 (pathname-unparse-name name type version)))

(define (unparse-directory directory)
  (cond ((or (null? directory) (eq? directory 'UNSPECIFIC)) "")
	((pair? directory)
	 (string-append
	  "["
	  (cond ((not (memq (car directory) '(ROOT UP)))
		 (string-append "." (unparse-directory-components directory)))
		((null? (cdr directory)) "")
		(else (unparse-directory-components (cdr directory))))
	  "]"))
	(else
	 (error "Unrecognizable directory" directory))))

(define (unparse-directory-components directory)
  (if (null? (cdr directory))
      (unparse-directory-component (car directory))
      (string-append (unparse-directory-component (car directory))
		     "."
		     (unparse-directory-components (cdr directory)))))

(define (unparse-directory-component component)
  (cond ((eq? component 'WILD) "*")
	((eq? component 'UP) "-")
	((string? component) component)
	(else (error "Illegal directory component" component))))

(define (pathname-unparse-name name type version)
  (let ((name (unparse-component name))
	(type (unparse-component type))
	(version (unparse-version version)))
    (cond ((not name) "")
	  ((not type) name)
	  ((not version) (string-append name "." type))
	  (else (string-append name "." type ";" version)))))

(define (unparse-component component)
  (cond ((or (not component) (string? component)) component)
	((eq? component 'UNSPECIFIC) false)
	((eq? component 'WILD) "*")
	(else (error "Illegal pathname component" component))))

(define (unparse-version version)
  (cond ((or (not version) (string? version)) version)
	((eq? version 'UNSPECIFIC) false)
	((eq? version 'WILD) "*")
	((eq? version 'NEWEST) "-1")
	((and (exact-integer? version) (positive? version))
	 (list->string (number->digits version '())))
	(else (error "Illegal pathname version" version))))

(define (number->digits number accumulator)
  (if (zero? number)
      accumulator
      (let ((qr (integer-divide number 10)))
	(number->digits (integer-divide-quotient qr)
			(cons (digit->char (integer-divide-remainder qr))
			      accumulator)))))