#| -*-Scheme-*-

$Header: filout.scm,v 14.7 90/11/09 08:43:49 GMT cph Rel $

Copyright (c) 1988, 1990 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; File Output Ports
;;; package: (runtime file-output)

(declare (usual-integrations))

(define (initialize-package!)
  (set! output-file-template
	(make-output-port `((BUFFER-SIZE ,operation/buffer-size)
			    (BUFFERED-CHARS ,operation/buffered-chars)
			    (CHANNEL ,operation/channel)
			    (CLOSE ,operation/close)
			    (FLUSH-OUTPUT ,operation/flush-output)
			    (PATHNAME ,operation/pathname)
			    (PRINT-SELF ,operation/print-self)
			    (SET-BUFFER-SIZE ,operation/set-buffer-size)
			    (TRUENAME ,operation/truename)
			    (WRITE-CHAR ,operation/write-char)
			    (WRITE-STRING ,operation/write-string))
			  false))
  unspecific)

(define (open-output-file filename #!optional append?)
  (let ((pathname (->pathname filename))
	(append? (and (not (default-object? append?)) append?)))
    (open-output-file/internal pathname
			       (if append?
				   (canonicalize-overwrite-pathname pathname)
				   (canonicalize-output-pathname pathname))
			       append?
			       buffer-size)))

(define (open-output-file/internal pathname truename append? buffer-size)
  (output-port/copy
   output-file-template
   (make-output-file-state
    (make-output-buffer (let ((filename (pathname->string truename)))
			  (if append?
			      (file-open-append-channel filename)
			      (file-open-output-channel filename)))
			buffer-size)
    pathname
    truename)))

(define output-file-template)
(define buffer-size 512)

(define-structure (output-file-state (type vector)
				     (conc-name output-file-state/))
  ;; Buffer must come first, so we can use operations from generic
  ;; output port implementation.
  (buffer false read-only true)
  (pathname false read-only true)
  (truename false read-only true))

(define (operation/pathname port)
  (output-file-state/pathname (output-port/state port)))

(define (operation/print-self state port)
  (unparse-string state "for file: ")
  (unparse-object state (pathname->string (operation/truename port))))

(define (operation/truename port)
  (output-file-state/truename (output-port/state port)))