signature StringParse =
sig

(* STRING CONVERTERS

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        14 Feb 1990

   Maintenance: Author


   DESCRIPTION

   Standard conversion functions on the built-in type "string".
   These expect strings to be surrounded by quotes and with appropriate
   characters escaped.


   NOTES

   These functions are provided separately to avoid repeating
   them in the StringObject and StringObject' structures.
*)

(* CONVERTERS *)

  val parse': string list ->
	      (string * string list, string Option * string list) Result

  val parse:  string -> (string, string Option) Result

  val read: InStream -> (string, string Option) Result

  val string: string -> string

end
