(*$Const *)

loadSig "Const";

structure Const: Const =

(* TAGGED VALUES

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk

   Date:	12 Dec 1989

   Maintenance:	Author


   NOTES

   An ML implementation could incorporate this package as equality on
   addresses.
*)

struct

  val version = 0.1


(* TYPES *)

  datatype 'a Const = Const of 'a * (unit ref)


(* CREATORS *)

  fun Create x = Const (x, ref ())


(* OBSERVERS *)

  fun eq (Const (_, t1)) (Const (_, t2)) = (t1 = t2)

  fun ne (Const (_, t1)) (Const (_, t2)) = (t1 <> t2)


(* SELECTORS *)

  fun !! (Const (x, _)) = x

end

