local

(* load base files; used by all parsers generated by ML-Yacc, included
   ML-Yacc's own parser *)

    val base = ["base.sig","stream.sml","lrtable.sml","join.sml","parser2.sml"]

(* load signatures and parser for ML-Yacc *)

    val parser = ["utils.sig","sigs.sml","hdr.sml","yacc.grm.sig",
 		  "yacc.grm.sml","yacc.lex.sml","parse.sml"]

(* load lr table generator:

	base definitions:
		 grammar.sml


	LR(0) graph generation:
		intgrammar.sml, core.sml, coreutils.sml, graph.sml

	LALR(1) table generation:
		look.sml, lalr.sml, mklrtable.sml

	modules to print out table structure:
		mkprstruct.sml
                shrink.sml

	and verbose file:
		verbose.sml

*)	

    val tablegen = ["utils.sml","sigs.sml","grammar.sml","core.sml",
		    "coreutils.sml","graph.sml","look.sml","lalr.sml",
		     "mklrtable.sml","mkprstruct.sml","shrink.sml","verbose.sml"]

(* rest of ML-Yacc:

        signature and module to handle abstract syntax for actions and remove
        unused variable bindings from the abstract syntax:
                absyn.sig
                absyn.sml

	module to check specification for errors, create grammar from
	specification, have appropriate files printed out, and print out
	semantic actions for the parser:
		yacc.sml

	module to hook everything together:
	        link.sml
*)

     val restgen = ["absyn.sig","absyn.sml","yacc.sml","link.sml"]
in
     val loadBase = fn _ => List.apply System.use base
     val loadParser = fn _ => List.apply System.use parser
     val loadPG = fn _ => List.apply System.use tablegen
     val loadRest = fn _ => List.apply System.use restgen
     val loadAll = fn _ => (loadBase(); loadParser(); loadPG();
			    loadRest())
end
