;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Changes:
;;;     8/24/92 Andrew Mickish - Added load of debug module
;;;     5/22/92 Brad Vander Zanden - Added kr-changes.lisp
;;; 	5/4/92 Ed Pervin - Changed Garnet-Lapidary-Pathname to 
;;;			  Garnet-Lapidary-Src.  Added "mouse-bindings"
;;;			  to list of files.
;;;

(in-package "USER" :use '("LISP"))

;; Only loads this file when not compiling all of Garnet.
(unless (boundp 'user::*Garnet-Going-To-Compile*)
  (load (merge-pathnames "multifont-loader"
			 #+cmu "opal:"
			 #+(not cmu) user::Garnet-Opal-PathName)))

;; load necessary gadgets
(dolist (gadget '("text-buttons-loader"
		 "error-gadget-loader"
                 "arrow-line-loader"
		 "labeled-box-loader"
		 "x-buttons-loader"
	 	 "v-slider-loader"
		 "scrolling-labeled-box-loader"
		 "radio-buttons-loader"
	 	 "scrolling-window-loader"
		 "scrolling-menu-loader"
		 "menubar-loader"
		 "prop-sheet-win-loader"))
	(load (merge-pathnames gadget
                           #+cmu "gadgets:"
                           #+(not cmu) user::Garnet-Gadgets-PathName)
          :verbose T))

;;;
;;;     Functions needed from Gilt
(load (merge-pathnames "gilt-functions-loader"
			 user::Garnet-Gilt-PathName))

;;; first load c32
(when (not (get :garnet-modules :c32))
      (load garnet-c32-loader))

(Defparameter Garnet-Lapidary-Files
  '(
;	"kr-changes"
        "lapidary-functions"
;        "c32-changes"
	"mouse-bindings"
	"parameters"
        "defs"
	"line-constraint-defs"
        "macros"
	"lapidary"  
	"dialog-parts2" "event-card" "card" "card1"
	"start-where" "prompt"
        "lapidary-objects"
	"feedback-objs"     "set-feedback"
	"support-misc"
	"support-properties"
	"support-selection1"	"support-selection2"   	"selection"
	"create-object"
	"delete-object"
        "delete-window"
	"move-grow"
	"support-constraints" "attach-constraints"
	"aggregates"
	"box-parts" "box" "support-box-constraints"
	"line-constraint-objs" "new-line-constraint"
	"aggparam" "create-parameters"
	"properties"
        "line-imp" "line-props"
	"fill-imp" "fill-props"
	"color-imp" "color-props"
	"shapes"
;	"draw"
	"lap-draw"
	"support-menu-editor"		        "new-editor"
        "text"   "text-properties"
        "gadgetcopy"
	"save-link-parameters"
        "lapidary-save"	"lapidary-read"	"support-save-restore" "save-restore"
	"add-gadget"
	"choice-inter" "text-inter"
	"move-grow-box" "support-move-grow-inter" "move-grow-inter" 
	"angle-inter" "two-point-inter"
	"support-inter" "by-demo"
	"interactors" "interactors-menu"))

(dolist (file Garnet-Lapidary-Files)
	 (compile-file (merge-pathnames file 
				#+cmu "lapidary-src:"
				#+(not cmu) Garnet-Lapidary-Src
				)
		       )
	 (load (merge-pathnames file 
				#+cmu "lapidary-src:"
				#+(not cmu) Garnet-Lapidary-Src
				)
		       ))
