;starting to add interactors
(in-package "USER" :use '("LISP"))

(use-package "KR")

;**************
;"global" stuff
;**************

(create-instance 'checker OPAL:AGGREGADGET
  (:EXPORT-P NIL)
  (:PACKAGE-NAME "USER")
  (:pretend-to-be-leaf t)
  (:OBJOVER NIL)
  (:checker-color opal:green-fill)
  (:checker-style (opal:read-image
		   "/afs/cs/user/bvz/garnet/lapidary/demo/bcrown"))
  (:LEFT (formula `(GVL :OBJOVER :LEFT ) 263))
  (:TOP (formula `(GVL :OBJOVER :TOP ) 215))
  (:WIDTH (formula `(ROUND (GVL :OBJOVER :WIDTH ) ) 50))
  (:HEIGHT (formula `(ROUND (GVL :OBJOVER :HEIGHT ) ) 50))
  (:parts `(
    (:SOLID-THIN-LINE-CIRCLE-35595 ,OPAL:CIRCLE
      (:FILLING-STYLE ,(o-formula (gvl :parent :checker-color)))
      (:LINE-STYLE ,OPAL:LINE-0)
      (:DIAMETER ,(o-formula (ROUND (+ (* (GVL :HEIGHT-SCALE) (GVL :HEIGHT-OVER :HEIGHT)) (GVL :HEIGHT-DIFFERENCE))) 50))
      (:RADIUS ,(o-formula (/ (GVL :DIAMETER) 2) 25))
      (:LEFT ,(formula `(GVL :PARENT :LEFT ) 263))
      (:TOP ,(formula `(GVL :PARENT :TOP ) 215))
      (:WIDTH ,(o-formula (GVL :DIAMETER) 50))
      (:HEIGHT ,(o-formula (GVL :DIAMETER) 50)))
    (:|33216| ,OPAL:BITMAP
      (:IMAGE ,(o-formula (gvl
			     :parent
			     :checker-style)))
      (:DRAW-FUNCTION :XOR)
      (:LEFT ,(formula `(FLOOR (- (+ (GVL :PARENT :SOLID-THIN-LINE-CIRCLE-35595 :LEFT ) (* (GVL :PARENT :SOLID-THIN-LINE-CIRCLE-35595 :WIDTH ) 0.5 ) 1 ) (/ (GVL :WIDTH ) 2 ) ) ) 274))
      (:TOP ,(formula `(FLOOR (- (+ (GVL :PARENT :SOLID-THIN-LINE-CIRCLE-35595 :TOP ) (* (GVL :PARENT :SOLID-THIN-LINE-CIRCLE-35595 :HEIGHT ) 0.5 ) 1 ) (/ (GVL :HEIGHT ) 2 ) ) ) 226))))))

(setq jump-flag nil)
(setq movement-list '(0 0 0 0))
(setq search-depth 2)
(setq square_size 50)
(setq window_top 350)
(setq window_left 520)

(defun do-go () 

(when (and (boundp 'game_window) (schema-p game_window ))
      (opal:destroy game_window))

;;; create the interface gadget 
(create-instance 'TEMP-GADGET OPAL:AGGREGADGET
  (:WINDOW-TITLE "Drawing Window 1")
  (:WINDOW-LEFT 0)
  (:WINDOW-TOP 359)
  (:WINDOW-WIDTH 618)
  (:WINDOW-HEIGHT 500)
  (:WINDOW-P T)
  (:EXPORT-P T)
  (:PACKAGE-NAME "USER")
  (:LEFT 0)
  (:TOP 0)
  (:WIDTH (o-formula (GVL :WINDOW :WIDTH) 618))
  (:HEIGHT (o-formula (GVL :WINDOW :HEIGHT) 500))
  (:parts `(
    (:CHECKERBOARD ,OPAL:AGGRELIST
      (:DIRECTION :HORIZONTAL)
      (:RANK-MARGIN 8)
      (:ITEMS 64)
      (:FIXED-WIDTH-P NIL)
      (:PIXEL-MARGIN NIL)
      (:H-SPACING -1)
      (:INDENT 0)
      (:FIXED-HEIGHT-P NIL)
      (:V-SPACING -1)
      (:SELECT-FUNCTION NIL)
      (:FIXED-WIDTH-SIZE NIL)
      (:FIXED-HEIGHT-SIZE NIL)
      (:H-ALIGN :LEFT)
      (:V-ALIGN :TOP)
      (:LEFT 201)
      (:TOP 19)
      (:VISIBLE T)
      (:item-prototype 
        (,OPAL:RECTANGLE
          (:FILLING-STYLE ,(formula `(WHICH-COLOR )))
          (:LINE-STYLE ,OPAL:LINE-0)
          (:P-FEEDBACK-OBJ NIL)
          (:BOX (109 28 50 50 ))
          (:LEFT 109)
          (:TOP 28)
          (:WIDTH 50)
          (:HEIGHT 50))))
    (:|35993| ,OPAL:AGGRELIST
      (:DIRECTION :VERTICAL)
      (:RANK-MARGIN 3)
      (:ITEMS ("begin green" "begin blue" "quit"))
      (:FIXED-WIDTH-P NIL)
      (:PIXEL-MARGIN NIL)
      (:FIXED-HEIGHT-P NIL)
      (:V-SPACING 15)
      (:SELECT-FUNCTION NIL)
      (:H-SPACING 5)
      (:FIXED-WIDTH-SIZE NIL)
      (:FIXED-HEIGHT-SIZE NIL)
      (:H-ALIGN :LEFT)
      (:V-ALIGN :TOP)
      (:INDENT 0)
      (:LEFT 24)
      (:TOP 120)
      (:VISIBLE T)
      (:item-prototype 
        (,OPAL:AGGREGADGET
          (:P-FEEDBACK-OBJ NIL)
          (:WIDTH-OVER ,(formula `(GVL :SOLID-THIN-LINE-RECTANGLE-35765 )))
          (:HEIGHT-OVER ,(formula `(GVL :SOLID-THIN-LINE-RECTANGLE-35765 )))
          (:WIDTH-DIFFERENCE 10)
          (:WIDTH-SCALE 1)
          (:MARK NIL)
          (:HEIGHT-DIFFERENCE 10)
          (:HEIGHT-SCALE 1)
          (:BOX (184 23 119 54 ))
	  (:string ,(o-formula (nth (gvl :rank) (gvl :parent :items))))
          (:LEFT 184)
          (:TOP 23)
          (:WIDTH ,(o-formula (ROUND (+ (* (GVL :WIDTH-SCALE) (GVL :WIDTH-OVER :WIDTH)) (GVL :WIDTH-DIFFERENCE))) 119))
          (:HEIGHT ,(o-formula (ROUND (+ (* (GVL :HEIGHT-SCALE) (GVL :HEIGHT-OVER :HEIGHT)) (GVL :HEIGHT-DIFFERENCE))) 54))
          (:parts (
            (:SOLID-THIN-LINE-RECTANGLE-35765 ,OPAL:RECTANGLE
              (:FILLING-STYLE ,OPAL:BLACK-FILL)
              (:LINE-STYLE ,OPAL:LINE-0)
              (:P-FEEDBACK-OBJ NIL)
              (:S-FEEDBACK-OBJ NIL)
              (:LEFT-OVER ,(formula `(GVL :PARENT )))
              (:LEFT-OFFSET 10)
              (:TOP-OVER ,(formula `(GVL :PARENT )))
              (:TOP-OFFSET 10)
              (:LEFT ,(o-formula (+ (GVL :LEFT-OVER :LEFT) (GVL :LEFT-OFFSET)) 194))
              (:TOP ,(o-formula (+ (GVL :TOP-OVER :TOP) (GVL :TOP-OFFSET)) 33))
              (:WIDTH 109)
              (:HEIGHT 44))
            (:SOLID-THIN-LINE-RECTANGLE-35767 ,OPAL:RECTANGLE
              (:FILLING-STYLE ,OPAL:GRAY-FILL)
              (:LINE-STYLE ,OPAL:LINE-0)
              (:P-FEEDBACK-OBJ NIL)
              (:S-FEEDBACK-OBJ NIL)
              (:LEFT-OFFSET ,(o-formula (if (gvl :parent :interim-selected) 0 -10)))
              (:LEFT-OVER ,(formula `(GVL :PARENT :SOLID-THIN-LINE-RECTANGLE-35765 )))
              (:TOP-OFFSET ,(o-formula (if (gvl :parent :interim-selected) 0 -10)))
              (:TOP-OVER ,(formula `(GVL :PARENT :SOLID-THIN-LINE-RECTANGLE-35765 )))
              (:WIDTH-DIFFERENCE 0)
              (:WIDTH-SCALE 1)
              (:WIDTH-OVER ,(formula `(GVL :PARENT :SOLID-THIN-LINE-RECTANGLE-35765 )))
              (:HEIGHT-DIFFERENCE 0)
              (:HEIGHT-SCALE 1)
              (:HEIGHT-OVER ,(formula `(GVL :PARENT :SOLID-THIN-LINE-RECTANGLE-35765 )))
              (:LEFT ,(o-formula (+ (GVL :LEFT-OVER :LEFT) (GVL :LEFT-OFFSET)) 184))
              (:TOP ,(o-formula (+ (GVL :TOP-OVER :TOP) (GVL :TOP-OFFSET)) 23))
              (:WIDTH ,(o-formula (ROUND (+ (* (GVL :WIDTH-SCALE) (GVL :WIDTH-OVER :WIDTH)) (GVL :WIDTH-DIFFERENCE))) 109))
              (:HEIGHT ,(o-formula (ROUND (+ (* (GVL :HEIGHT-SCALE) (GVL :HEIGHT-OVER :HEIGHT)) (GVL :HEIGHT-DIFFERENCE))) 44)))
            (:MEDIUM-TEXTURE-THIN-LINE-RECTANGLE-35769 ,OPAL:RECTANGLE
              (:FILLING-STYLE ,(create-instance nil OPAL:FILLING-STYLE
                    (:STIPPLE OPAL::GRAY-FILL-BITMAP)
                    (:FOREGROUND-COLOR OPAL:WHITE)
                    (:FILL-STYLE :OPAQUE-STIPPLED)))
              (:LINE-STYLE ,OPAL:LINE-0)
              (:P-FEEDBACK-OBJ NIL)
              (:S-FEEDBACK-OBJ NIL)
              (:TOP-OFFSET 0.5)
              (:TOP-OVER ,(formula `(GVL :PARENT :SOLID-THIN-LINE-RECTANGLE-35767 )))
              (:LEFT-OFFSET 0.5)
              (:LEFT-OVER ,(formula `(GVL :PARENT :SOLID-THIN-LINE-RECTANGLE-35767 )))
              (:WIDTH-DIFFERENCE -15)
              (:WIDTH-SCALE 1)
              (:WIDTH-OVER ,(formula `(GVL :PARENT :SOLID-THIN-LINE-RECTANGLE-35767 )))
              (:HEIGHT-DIFFERENCE -15)
              (:HEIGHT-SCALE 1)
              (:HEIGHT-OVER ,(formula `(GVL :PARENT :SOLID-THIN-LINE-RECTANGLE-35767 )))
              (:LEFT ,(o-formula (FLOOR (- (+ (GVL :LEFT-OVER :LEFT) (* (GVL :LEFT-OVER :WIDTH) (GVL :LEFT-OFFSET)) 1) (/ (GVL :WIDTH) 2))) 192))
              (:TOP ,(o-formula (FLOOR (- (+ (GVL :TOP-OVER :TOP) (* (GVL :TOP-OVER :HEIGHT) (GVL :TOP-OFFSET)) 1) (/ (GVL :HEIGHT) 2))) 31))
              (:WIDTH ,(o-formula (ROUND (+ (* (GVL :WIDTH-SCALE) (GVL :WIDTH-OVER :WIDTH)) (GVL :WIDTH-DIFFERENCE))) 94))
              (:HEIGHT ,(o-formula (ROUND (+ (* (GVL :HEIGHT-SCALE) (GVL :HEIGHT-OVER :HEIGHT)) (GVL :HEIGHT-DIFFERENCE))) 29)))
            (:TEXT-35772 ,OPAL:CURSOR-TEXT
              (:STRING ,(o-formula (gvl :parent :string)))
              (:CURSOR-INDEX NIL)
              (:FONT ,(create-instance nil OPAL:FONT))
              (:P-FEEDBACK-OBJ NIL)
              (:LEFT-OFFSET 0.5)
              (:TOP-OFFSET 0.5)
              (:TOP-OVER ,(formula `(GVL :PARENT :MEDIUM-TEXTURE-THIN-LINE-RECTANGLE-35769 )))
              (:LEFT-OVER ,(formula `(GVL :PARENT :MEDIUM-TEXTURE-THIN-LINE-RECTANGLE-35769 )))
              (:S-FEEDBACK-OBJ NIL)
              (:LEFT ,(o-formula (FLOOR (- (+ (GVL :LEFT-OVER :LEFT) (* (GVL :LEFT-OVER :WIDTH) (GVL :LEFT-OFFSET)) 1) (/ (GVL :WIDTH) 2))) 202))
              (:TOP ,(o-formula (FLOOR (- (+ (GVL :TOP-OVER :TOP) (* (GVL :TOP-OVER :HEIGHT) (GVL :TOP-OFFSET)) 1) (/ (GVL :HEIGHT) 2))) 39)))))))
      (:interactors (
        (NIL ,INTERACTORS:MENU-INTERACTOR
          (:LAPIDARY-P T)
	  (:final-function menu-handler)
          (:START-WHERE ,(formula `(LIST :ELEMENT-OF (GVL :OPERATES-ON ) )))
          (:FEEDBACK-OBJ NIL)
          (:ACTIVE T)
          (:SAVE-VALUES ((:ACTIVE . T) ))
          (:WINDOW ,(formula `(IF (GVL :OPERATES-ON ) (GVL :OPERATES-ON :WINDOW ) (LET ((LAPIDARY::START-WHERE (GVL :START-WHERE ) ) ) (COND ((EQ LAPIDARY::START-WHERE T ) T ) ((EQ LAPIDARY::START-WHERE NIL ) NIL ) (T (CASE (FIRST LAPIDARY::START-WHERE ) ((:IN :IN-BOX :IN-BUT-NOT-ON :ELEMENT-OF :LEAF-ELEMENT-OF :ELEMENT-OF-OR-NONE :LEAF-ELEMENT-OF-OR-NONE :CHECK-LEAF-BUT-RETURN-ELEMENT :CHECK-LEAF-BUT-RETURN-ELEMENT-OF-OR-NONE ) (GV (SECOND LAPIDARY::START-WHERE ) :WINDOW ) ) ((:LIST-ELEMENT-OF :LIST-LEAF-ELEMENT-OF :LIST-ELEMENT-OF-OR-NONE :LIST-LEAF-ELEMENT-OF-OR-NONE :LIST-CHECK-LEAF-BUT-RETURN-ELEMENT :LIST-CHECK-LEAF-BUT-RETURN-ELEMENT-OR-NONE ) (LET ((LAPIDARY::WINDOW-LIST NIL ) ) (DOLIST (LAPIDARY::OBJ (GV (SECOND LAPIDARY::START-WHERE ) (THIRD LAPIDARY::START-WHERE ) ) ) (LET ((LAPIDARY::WINDOW (G-LOCAL-VALUE LAPIDARY::OBJ :WINDOW ) ) ) (WHEN LAPIDARY::WINDOW (PUSHNEW LAPIDARY::WINDOW LAPIDARY::WINDOW-LIST ) ) ) ) LAPIDARY::WINDOW-LIST ) ) (T NIL ) ) ) ) ) )))))))
      (:MEDIUM-TEXTURE-THIN-LINE-RECTANGLE-36410 ,OPAL:RECTANGLE
        (:FILLING-STYLE ,(create-instance nil OPAL:FILLING-STYLE
              (:STIPPLE OPAL::GRAY-FILL-BITMAP)
              (:FOREGROUND-COLOR OPAL:WHITE)
              (:FILL-STYLE :OPAQUE-STIPPLED)))
        (:LINE-STYLE ,OPAL:LINE-0)
        (:LEFT ,(formula `(GVL :PARENT :|35993| :LEFT ) 201))
        (:TOP 433)
        (:WIDTH ,(formula `(- (opal:gv-right (gvl :parent :checkerboard))
			      (GVL :PARENT :|35993| :left)) 393))
        (:HEIGHT 36))
      (:STATUS-BAR ,OPAL:CURSOR-TEXT
        (:STRING "Please press a button to get us started.")
        (:CURSOR-INDEX NIL)
        (:FONT ,(create-instance nil OPAL:FONT))
        (:LEFT ,(formula `(+ (GVL :PARENT :MEDIUM-TEXTURE-THIN-LINE-RECTANGLE-36410 :LEFT ) 10 ) 211))
        (:TOP ,(formula `(FLOOR (- (+ (GVL :PARENT :MEDIUM-TEXTURE-THIN-LINE-RECTANGLE-36410 :TOP ) (* (GVL :PARENT :MEDIUM-TEXTURE-THIN-LINE-RECTANGLE-36410 :HEIGHT ) 0.5 ) 1 ) (/ (GVL :HEIGHT ) 2 ) ) ) 445))))))

;******************************************
;set up initial opal window with game board
;******************************************
;set up window
(create-instance 'game_window inter:interactor-window
  (:double-buffered-p t)
  (:top (- window_top 54))
  (:left window_left)
  (:width 618)
  (:height 500))

;set up game window aggregate
(create-instance 'game-aggregate opal:aggregadget)
(s-value game_window :aggregate game-aggregate)

(opal:add-component game-aggregate temp-gadget)

(create-instance 'feedback-aggregate opal:aggregadget)
(opal:add-component game-aggregate feedback-aggregate)

;set up the feedback circle
(create-instance 'feedback-circle opal:circle
  (:box '(0 0 10 10))
  (:obj-over NIL)
  (:visible (o-formula (gvl :obj-over)))
  (:left (o-formula (first (gvl :box))))
  (:top (o-formula (second (gvl :box))))
  (:width (o-formula (third (gvl :box))))
  (:height (o-formula (fourth (gvl :box))))
  (:fast-redraw-p T)
  (:draw-function :xor)
  (:filling-style nil)
  (:line-style opal:dashed-line))
; (opal:add-component feedback-aggregate feedback-circle)


#|
;set up the move checkers interactor
(create-instance NIL inter:move-grow-interactor
  (:window game_window)
  (:line-p nil)
  (:where-attach :center)
  (:running-where (list :in (g-value temp-gadget :checkerboard)))
  (:start-where (list :element-of temp-gadget :type checker))
  (:final-function #'move-checker-function)
  (:feedback-obj feedback-circle))
|#

;set up the move checkers interactor
(create-instance NIL inter:two-point-interactor
  (:window game_window)
  (:flip-if-change-side T)
  (:line-p T)
  (:start-where (list :in (g-value temp-gadget :checkerboard)))
  (:final-function #'move-checker-function)
  (:feedback-obj feedback-circle))

;************************
;set up template checkers
;************************
(setq checkers (make-array '(8 8)))

(let ((components (get-values (g-value temp-gadget :checkerboard) :components)))

(dolist (i '(1 3 5 7 10 12 14 16 21 23 25 27 30 32 34 36 41 43 45 47
	       50 52 54 56 61 63 65 67 70 72 74 76))
	(multiple-value-bind (row col) (truncate i 10)
			     (setf (aref checkers row col)
				   (create-instance nil checker
				      (:objover (nth (+ (* row 8) col) 
						     components)))))))

;set up initial array with no checkers in it
(setq current-board (make-array '(8 8) :initial-element 0))

;display game board
(opal:update game_window)
(inter:main-event-loop)
)

(defun do-stop ()
  (opal:destroy game_window))

(defun which-color ()
  (let ((rank (gvl :rank)))
    (if (null rank)
        opal:red-fill
        (multiple-value-bind (row col)
                             (truncate rank (gvl :parent :rank-margin))
                             (if (or (and (oddp row) (oddp col))
                                     (and (evenp row) (evenp col)))
                                 opal:red-fill
                                 opal:black-fill)))))

#|
;what to do when the mouse moves a checker
(defun move-checker-function (an-interactor points-list)
  (declare (special temp-gadget))
  (let (move-flag
	(status-bar (g-value temp-gadget :status-bar)))
       (setq movement-list (convert-box obj points-list))
       (setq move-flag (make-move (list (first movement-list)
					(second movement-list))
				  (list (third movement-list)
					(fourth movement-list))))
       (if (not move-flag)
	   (setq move-flag (make-move (list (third movement-list)
					    (fourth movement-list))
				      (list (first movement-list)
					    (second movement-list)))))
       (if move-flag
	   (if (eq move-flag 2)
	       (let (tmp)
		    (s-value status-bar :string
			     "Move again.")
		    (opal:update game_window))
	       (let (computer-flag)
		    (s-value status-bar :string
			     "Please be patient while I make my move...")
		    (opal:update game_window)
		    (setq computer-flag (perform-move search-depth))
		    (if computer-flag
			(s-value status-bar :string
				 "Your turn.")
			(s-value status-bar :string
				 "You win."))))
	   (s-value status-bar :string
		    "Illegal move.  Please try again."))))
|#

;what to do when the mouse moves a checker
(defun move-checker-function (an-interactor points-list)
  (let (move-flag
	(status-bar (g-value temp-gadget :status-bar)))
       (setq movement-list (convert-box points-list))
       (setq move-flag (make-move (list (first movement-list)
					(second movement-list))
				  (list (third movement-list)
					(fourth movement-list))))
       (if (not move-flag)
	   (setq move-flag (make-move (list (third movement-list)
					    (fourth movement-list))
				      (list (first movement-list)
					    (second movement-list)))))
       (if move-flag
	   (if (eq move-flag 2)
	       (let (tmp)
		    (s-value status-bar :button-string
			     "Move again.")
		    (opal:update game_window))
	       (let (computer-flag)
		    (s-value status-bar :button-string
			     "Please be patient while I make my move...")
		    (opal:update game_window)
		    (setq computer-flag (perform-move search-depth))
		    (if computer-flag
			(s-value status-bar :button-string
				 "Your turn.")
			(s-value status-bar :button-string
				 "You win."))))
	   (s-value status-bar :button-string
		    "Illegal move.  Please try again."))))

(defun menu-handler (inter selection)
  (declare (ignore inter))
  ;; find the text item in the selection
  (let (string text-item)
    (setf text-item
	  (dolist (obj (get-values selection :components))
		  (when (is-a-p obj opal:text)
			(return obj))))
    (setf string (g-value text-item :string))
  (cond ((string= string "begin green") (start-white-goes-first))
	((string= string "quit") 
	 (opal:destroy game_window)
	 (inter:exit-main-event-loop))
	((string= string "begin blue")
	 (start-black-goes-first)))))			     

;*******************************************
;apply a list of changes to game board array
;*******************************************
(defun apply-move-to-array (board changes)
  (dolist (change changes)
	  (if (eq (first change) 'r)
	      (setf (aref board (third change) (fourth change))
		    0)
	      (setf (aref board (third change) (fourth change))
		    (second change)))))

;*************************
;determine if game is over
;*************************
(defun game-overp (board)
  (let (black-flag white-flag)
       (setq black-flag nil)
       (setq white-flag nil)
       (dolist (row '(1 3 5 7))
	       (dolist (column '(0 2 4 6))
		       (cond ((> (aref board row column) 0)
			      (setq white-flag t))
			     ((< (aref board row column) 0)
			      (setq black-flag t)))))
       (dolist (row '(0 2 4 6))
	       (dolist (column '(1 3 5 7))
		       (cond ((> (aref board row column) 0)
			      (setq white-flag t))
			     ((< (aref board row column) 0)
			      (setq black-flag t)))))
       (if (and black-flag white-flag)
	   nil
	   (if black-flag
	       -1
	       1))))

;********************************************
;apply changes to both garnet board and array
;********************************************
(defun apply-changes (changes)
  (let (tmp)
       (apply-move-to-array current-board changes)
       (apply-move-to-pieces changes)))

;******************************
;calculate the value of a board
;******************************
(defun static-evaluator (board)
  (let (value black-flag white-flag)
       (setq value 0)
       (setq black-flag nil)
       (setq white-flag nil)
       (dolist (row '(1 3 5 7))
	       (dolist (column '(0 2 4 6))
		       (setq value (+ value
				      (aref board row column)))
		       (cond ((< (aref board row column) 0)
			      (setq black-flag t))
			     ((> (aref board row column) 0)
			      (setq white-flag t)))))
       (dolist (row '(0 2 4 6))
	       (dolist (column '(1 3 5 7))
		       (setq value (+ value
				      (aref board row column)))
		       (cond ((< (aref board row column) 0)
			      (setq black-flag t))
			     ((> (aref board row column) 0)
			      (setq white-flag t)))))
       (cond ((and black-flag white-flag)
	      value)
	     (black-flag -1000)
	     (t 1000))))

;*************************************************
;initialize game board into starting configuration
;*************************************************
(defun initialize-board ()
  (let (changes)
       (setq changes nil)
       (dotimes (row 8)
		(dotimes (column 8)
			 (if (not (eq (aref current-board row column) 0))
			     (setq changes (cons (list 'r
						       (aref current-board
							     row column)
						       row
						       column)
						 changes)))))
       (apply-move-to-pieces changes)
       (setf (aref current-board 0 1) 1)
       (setf (aref current-board 0 3) 1)
       (setf (aref current-board 0 5) 1)
       (setf (aref current-board 0 7) 1)
       (setf (aref current-board 1 0) 2)
       (setf (aref current-board 1 2) 2)
       (setf (aref current-board 1 4) 2)
       (setf (aref current-board 1 6) 2)
       (setf (aref current-board 2 1) 3)
       (setf (aref current-board 2 3) 3)
       (setf (aref current-board 2 5) 3)
       (setf (aref current-board 2 7) 3)
       (setf (aref current-board 3 0) 0)
       (setf (aref current-board 3 2) 0)
       (setf (aref current-board 3 4) 0)
       (setf (aref current-board 3 6) 0)
       (setf (aref current-board 4 1) 0)
       (setf (aref current-board 4 3) 0)
       (setf (aref current-board 4 5) 0)
       (setf (aref current-board 4 7) 0)
       (setf (aref current-board 5 0) -3)
       (setf (aref current-board 5 2) -3)
       (setf (aref current-board 5 4) -3)
       (setf (aref current-board 5 6) -3)
       (setf (aref current-board 6 1) -2)
       (setf (aref current-board 6 3) -2)
       (setf (aref current-board 6 5) -2)
       (setf (aref current-board 6 7) -2)
       (setf (aref current-board 7 0) -1)
       (setf (aref current-board 7 2) -1)
       (setf (aref current-board 7 4) -1)
       (setf (aref current-board 7 6) -1)
       (apply-move-to-pieces '((a 1 0 1) (a 1 0 3) (a 1 0 5) (a 1 0 7)
			       (a 2 1 0) (a 2 1 2) (a 2 1 4) (a 2 1 6)
			       (a 3 2 1) (a 3 2 3) (a 3 2 5) (a 3 2 7)
			       (a -3 5 0) (a -3 5 2) (a -3 5 4) (a -3 5 6)
			       (a -2 6 1) (a -2 6 3) (a -2 6 5) (a -2 6 7)
			       (a -1 7 0) (a -1 7 2) (a -1 7 4) (a -1 7 6)))))

;***********************************************
;copy a game board array, returning the new copy
;***********************************************
(defun copy-board-array (board)
  (let (new-board)
       (setq new-board (make-array '(8 8) :initial-element 0))
       (dolist (row '(1 3 5 7))
	       (dolist (column '(0 2 4 6))
		       (setf (aref new-board row column)
			     (aref board row column))))
       (dolist (row '(0 2 4 6))
	       (dolist (column '(1 3 5 7))
		       (setf (aref new-board row column)
			     (aref board row column))))
       new-board))

;********************************************
;apply list of changes to garnet checkerboard
;********************************************
(defun apply-move-to-pieces (changes)
  (let (tmp)
       (dolist (change changes)
	       (if (eq (first change) 'r)
		   (opal:remove-component temp-gadget
					  (aref checkers
						(third change)
						(fourth change)))
		   (cond ((eq (second change) -15)
			  (s-value (aref checkers
					 (third change)
					 (fourth change))
				   :checker-color opal:blue-fill)
			  (s-value (aref checkers 
					 (third change)
					 (fourth change))
				   :checker-style (opal:read-image
						   "/afs/cs/user/bvz/garnet/lapidary/demo/wcrown"))
			  (opal:add-component temp-gadget
					      (aref checkers
						    (third change)
						    (fourth change))))
			 ((< (second change) 0)
			  (s-value (aref checkers
					 (third change)
					 (fourth change))
				   :checker-color opal:blue-fill)
			  (s-value (aref checkers
					 (third change)
					 (fourth change))
				   :checker-style (opal:read-image
				  "/afs/cs/user/bvz/garnet/lapidary/demo/wstar"))
			  (opal:add-component temp-gadget
					      (aref checkers
						    (third change)
						    (fourth change))))
			 ((eq (second change) 15)
			  (s-value (aref checkers
					 (third change)
					 (fourth change))
				   :checker-color opal:green-fill)
			  (s-value (aref checkers
					 (third change)
					 (fourth change))
				   :checker-style (opal:read-image
						   "/afs/cs/user/bvz/garnet/lapidary/demo/wcrown"))
			  (opal:add-component temp-gadget
					      (aref checkers
						    (third change)
						    (fourth change))))
			 ((> (second change) 0)
			  (s-value (aref checkers
					 (third change)
					 (fourth change))
				   :checker-color opal:green-fill)
			  (s-value (aref checkers
					 (third change)
					 (fourth change))
				   :checker-style (opal:read-image
						   "/afs/cs/user/bvz/garnet/lapidary/demo/wstar"))
			  (opal:add-component temp-gadget
					      (aref checkers
						    (third change)
						    (fourth change)))))))
       (opal:update game_window)))

;****************************
;generate children of a board
;****************************
(defun generate-children (board color)
  (let (children black white)
       (setq children nil)
       (setq black (if (eq color 'b)
		       t
		       nil))
       (setq white (if (eq color 'w)
		       t
		       nil))
       (dotimes (row 8)
		(dotimes (column 8)
			 (if (or (and black
				      (< (aref board row column) 0))
				 (and white
				      (> (aref board row column) 0)))
			     (setq children
				   (append (jump-moves board
						       row
						       column
						       color)
					   children)))))
       (if (eq children nil)
	   (let (tmp)
		(dotimes (row 8)
			 (dotimes (column 8)
				  (if (or (and black
					       (< (aref board row column) 0))
					  (and white
					       (> (aref board row column) 0)))
				      (setq children
					    (append (regular-moves board
								   row
								   column
								   color)
						    children)))))
		(setq jump-flag nil))
	   (setq jump-flag t))
       children))

;***************************
;list possible regular moves
;***************************
(defun regular-moves (board row column color)
  (let (children current-piece king)
       (setq children nil)
       (setq current-piece (aref board row column))
       (setq king (if (eq (abs current-piece) 15)
		      t
		      nil))
       
       ;do moves "up" the board
       (if (and (or (eq color 'b)
		    king)
		(> row 0))
	   (let (moves)
		
		;move to right
		(if (and (< column 7)
			 (eq (aref board (1- row) (1+ column)) 0))
		    (let (child)
			 (setq child (copy-board-array board))
			 (setf (aref child (1- row) (1+ column))
			       (if king
				   current-piece
				   (1- current-piece)))
			 (setf (aref child row column) 0)
			 (setq children (cons child children))))
		
		;move to left
		(if (and (> column 0)
			 (eq (aref board (1- row) (1- column)) 0))
		    (let (child)
			 (setq child (copy-board-array board))
			 (setf (aref child (1- row) (1- column))
			       (if king
				   current-piece
				   (1- current-piece)))
			 (setf (aref child row column) 0)
			 (setq children (cons child children))))))
       
       ;do moves "down" the board
       (if (and (or (eq color 'w)
		    king)
		(< row 7))
	   (let (moves)
		
		;move to right
		(if (and (< column 7)
			 (eq (aref board (1+ row) (1+ column)) 0))
		    (let (child)
			 (setq child (copy-board-array board))
			 (setf (aref child (1+ row) (1+ column))
			       (if king
				   current-piece
				   (1+ current-piece)))
			 (setf (aref child row column) 0)
			 (setq children (cons child children))))
		
		;move to left
		(if (and (> column 0)
			 (eq (aref board (1+ row) (1- column)) 0))
		    (let (child)
			 (setq child (copy-board-array board))
			 (setf (aref child (1+ row) (1- column))
			       (if king
				   current-piece
				   (1+ current-piece)))
			 (setf (aref child row column) 0)
			 (setq children (cons child children))))))
       (dolist (child children)
	       (crown-array child))
       children))

;********************************************************************
;generate a list of moves required to change board-dst into board-src
;********************************************************************

(defun list-moves (board-src board-dst)
  (let (moves)
       (setq moves nil)
       (dotimes (row 8)
		(dotimes (column 8)
			 (if (not (eq (aref board-src row column)
				      (aref board-dst row column)))
			     (cond ((eq (aref board-src row column) 0)
				    (setq moves
					  (cons (list 'r
						      (aref board-dst
							    row
							    column)
						      row
						      column)
						moves)))
				   ((eq (aref board-dst row column) 0)
				    (setq moves
					  (cons (list 'a
						      (aref board-src
							    row
							    column)
						      row
						      column)
						moves)))
				   (t
				    (setq moves
					  (append (list
						   (list 'r
							 (aref board-dst
							       row
							       column)
							 row
							 column)
						   (list 'a
							 (aref board-src
							       row
							       column)
							 row
							 column))
						  moves)))))))
       moves))

;********************************
;generate jump moves from a board
;********************************
(defun jump-moves (board row column color)
  (let (children current-piece king black white)
       (setq children nil)
       (setq current-piece (aref board row column))
       (setq king (if (eq (abs current-piece) 15)
		      t
		      nil))
       (setq black (if (eq color 'b)
		       t
		       nil))
       (setq white (if (eq color 'w)
		       t
		       nil))
       
       ;jump northeast
       (if (and (> row 1)
		(< column 6)
		(eq (aref board (- row 2) (+ column 2)) 0)
		(or (and black
			 (> (aref board (1- row) (1+ column)) 0))
		    (and white
			 (< (aref board (1- row) (1+ column)) 0)))
		(or black king))
	   (let (child more-children)
		(setq child (copy-board-array board))
		(setf (aref child (- row 2) (+ column 2))
		      (if king
			  current-piece
			  (- current-piece 2)))
		
		(setf (aref child (1- row) (1+ column)) 0)
		(setf (aref child row column) 0)
		(crown-array child)
		(setq more-children (jump-moves child
						(- row 2)
						(+ column 2)
						color))
		(if (eq more-children nil)
		    (setq children (cons child children))
		    (setq children (append children more-children)))))
       
       ;jump northwest
       (if (and (> row 1)
		(> column 1)
		(eq (aref board (- row 2) (- column 2)) 0)
		(or (and black
			 (> (aref board (1- row) (1- column)) 0))
		    (and white
			 (< (aref board (1- row) (1- column)) 0)))
		(or black king))
	   (let (child more-children)
		(setq child (copy-board-array board))
		(setf (aref child (- row 2) (- column 2))
		      (if king
			  current-piece
			  (- current-piece 2)))
		(setf (aref child (1- row) (1- column)) 0)
		(setf (aref child row column) 0)
		(crown-array child)
		(setq more-children (jump-moves child
						(- row 2)
						(- column 2)
						color))
		(if (eq more-children nil)
		    (setq children (cons child children))
		    (setq children (append more-children children)))))
       
       ;jump southeast
       (if (and (< row 6)
		(< column 6)
		(eq (aref board (+ row 2) (+ column 2)) 0)
		(or (and black
			 (> (aref board (1+ row) (1+ column)) 0))
		    (and white
			 (< (aref board (1+ row) (1+ column)) 0)))
		(or white king))
	   (let (child more-children)
		(setq child (copy-board-array board))
		(setf (aref child (+ row 2) (+ column 2))
		      (if king
			  current-piece
			  (+ current-piece 2)))
		(setf (aref child (1+ row) (1+ column)) 0)
		(setf (aref child row column) 0)
		(crown-array child)
		(setq more-children (jump-moves  child
						 (+ row 2)
						 (+ column 2)
						 color))
		(if (eq more-children nil)
		    (setq children (cons child children))
		    (setq children (append more-children children)))))
       
       ;jump southwest
       (if (and (< row 6)
		(> column 1)
		(eq (aref board (+ row 2) (- column 2)) 0)
		(or (and black
			 (> (aref board (1+ row) (1- column)) 0))
		    (and white
			 (< (aref board (1+ row) (1- column)) 0)))
		(or white king))
	   (let (child more-children)
		(setq child (copy-board-array board))
		(setf (aref child (+ row 2) (- column 2))
		      (if king
			  current-piece
			  (+ current-piece 2)))
		(setf (aref child (1+ row) (1- column)) 0)
		(setf (aref child row column) 0)
		(crown-array child)
		(setq more-children (jump-moves child
						(+ row 2)
						(- column 2)
						color))
		(if (eq more-children nil)
		    (setq children (cons child children))
		    (setq children (append more-children children)))))
       
       children))

;*****************************************
;compute the alphabeta value of a game board
;*****************************************
(defun alphabeta (board color depth alpha beta)
  (let (game-over-flag)
       (setq game-over-flag (game-overp board))
       (cond ((eq game-over-flag -1) -1000)
	     ((eq game-over-flag  1)  1000)
	     ((and (< depth 1)
		   (eq jump-flag nil))
	      (static-evaluator board))
	     (t
	      (let (children)
		   (setq children (generate-children board
						     color))
		   (if (eq children nil)
		       (if (eq color 'b)
			   1000
			   -1000)
		       (let (values dont-cutoff)
			    (setq dont-cutoff t)
			    (setq values nil)
			    (dolist (child children)
				    (if dont-cutoff
					(let (tmp)
					     (setq tmp (alphabeta
							child
							(other-color color)
							(1- depth)
							alpha
							beta))
					     (if (or (and (eq color 'b)
							  (< tmp alpha))
						     (and (eq color 'w)
							  (> tmp beta)))
						 (setq dont-cutoff nil))
					     (if (and (eq color 'b)
						      (< tmp beta))
						 (setq beta tmp))
					     (if (and (eq color 'w)
						      (> tmp alpha))
						 (setq alpha tmp))
					     (setq values
						   (cons tmp values)))))
			    
			    
			    (if (eq color 'b)
				(minimum values)
				(maximum values)))))))))

;******************************
;return maximum value in a list
;******************************
(defun maximum (values)
  (let (maxi)
       (setq maxi (car values))
       (dolist (value values)
	       (setq maxi (if (< maxi value)
			      value
			      maxi)))
       maxi))

;******************************
;return minimum value in a list
;******************************
(defun minimum (values)
  (let (mini)
       (setq mini (car values))
       (dolist (value values)
	       (setq mini (if (> mini value)
			      value
			      mini)))
       mini))

;*********************
;return opposite color
;*********************
(defun other-color (color)
  (if (eq color 'w)
      'b
      'w))

;**************************************
;turn boarder star checkers into crowns
;**************************************
(defun crown-array (board)
  (let (tmp)
       (dolist (column '(1 3 5 7))
	       (if (< (aref board 0 column) 0)
		   (setf (aref board 0 column) -15)))
       (dolist (column '(0 2 4 6))
	       (if (> (aref board 7 column) 0)
		   (setf (aref board 7 column) 15)))))

;************************************************
;let computer (white checker) choose a move
;returns a checkerboard array containing its move
;************************************************
(defun computer-move (depth)
  (let (children)
       (setq children (generate-children current-board 'w))
       (cond ((eq children nil)
	      nil)
	     ((eq (cdr children) nil)
	      (car children))
	     
	     (t
	      (let (values maxi pos alpha beta)
		   (setq values nil)
		   (setq alpha -1500)
		   (setq beta 1500)
		   (dolist (child children)
			   (setq maxi (alphabeta child 'b (1- depth)
						 alpha beta))
			   (if (> maxi alpha)
			       (setq alpha maxi))
			   (setq values (cons maxi values)))
		   (setq values (reverse values))
		   (setq maxi (maximum values))
		   (setq pos (position maxi values))
		   (nth pos children))))))

;***************************************************************
;perform computer move, returns nil if no move made, t otherwise
;***************************************************************
(defun perform-move (depth)
  (let (move)
       (setq move (computer-move depth))
       (if (eq move nil)
	   nil
	   (let (tmp)
		(apply-changes (list-moves move current-board))
		t))))

;**********************************************************
;is a move of the checker from to square1 to square2 legal?
;**********************************************************
(defun legal-movep (square1 square2)
  (let (row1 column1 row2 column2 color1 color-jumped king)
       (setq row1 (car square1))
       (setq column1 (cadr square1))
       (setq row2 (car square2))
       (setq column2 (cadr square2))
       (setq color1 (if (< (aref current-board row1 column1) 0)
			'b
			'w))
       (setq king (if (eq (abs (aref current-board row1 column1)) 15)
		      t
		      nil))
       
       ;check geometry and existence of pieces at src and dest
       (cond ((or (> row1 7)
		  (> row2 7)
		  (> column1 7)
		  (> column2 7)
		  (< row1 0)
		  (< row2 0)
		  (< column1 0)
		  (< column2 0)
		  (> (abs (- row1 row2)) 2)
		  (eq row1 row2)
		  (not (eq (abs (- row1 row2))
			   (abs (- column1 column2))))
		  (not (eq (aref current-board row2 column2) 0))
		  (eq (aref current-board row1 column1) 0)
		  (and (eq color1 'b)
		       (> (aref current-board row1 column1) -15)
		       (< row1 row2))
		  (and (eq color1 'w)
		       (< (aref current-board row1 column1) 15)
		       (> row1 row2)))
	      nil)
	     
	     ;a single-space move is OK if there are no jumps
	     ((eq (abs (- row1 row2)) 1)
	      (if (eq (jump-movesp) nil)
		  t
		  nil))
	     
	     ;check jump-move
	     (t
	      (setq color-jumped (cond ((< (aref current-board
						 (/ (+ row1 row2) 2)
						 (/ (+ column1 column2) 2))
					   0)
					'b)
				       ((> (aref current-board
						 (/ (+ row1 row2) 2)
						 (/ (+ column1 column2) 2))
					   0)
					'w)
				       (t color1)))
	      (if (eq color-jumped color1)
		  nil
		  t)))))

;*************************************
;make a move from square1 to square2
;return t if successful, nil otherwise
;*************************************
(defun make-move (square1 square2)
  (let (row1 column1 row2 column2)
       (setq row1 (car square1))
       (setq row2 (car square2))
       (setq column1 (cadr square1))
       (setq column2 (cadr square2))
       (if (and (< (aref current-board row1 column1) 0)
		(legal-movep square1 square2))
	   (let (new-value moves)
		(setq new-value (+ (aref current-board row1 column1)
				   (- row2 row1)))
		(if (> new-value 7)
		    (setq new-value 15))
		(if (< new-value -7)
		    (setq new-value -15))
		(setq moves (list (list 'r
					(aref current-board row1 column1)
					row1
					column1)
				  (list 'a
					new-value
					row2
					column2)))
		(if (eq (abs (- row1 row2)) 2)
		    (setq moves (cons (list 'r
					    (aref current-board
						  (/ (+ row1 row2) 2)
						  (/ (+ column1 column2) 2))
					    (/ (+ row1 row2) 2)
					    (/ (+ column1 column2) 2))
				      moves)))
		(apply-changes moves)
		(if (and (eq (abs ( - row1 row2)) 2)
			 (jump-moves current-board
				     row2
				     column2
				     'b))
		    2
		    t))
	   nil)))

;***********************************
;are there any jump moves for black?
;***********************************
(defun jump-movesp ()
  (let (moves-flag)
       (setq moves-flag nil)
       (dolist (row '(1 3 5 7))
	       (dolist (column '(0 2 4 6))
		       (if (< (aref current-board row column) 0)
			   (if (jump-moves current-board
					   row
					   column
					   'b)
			       (setq moves-flag t)))))
       (dolist (row '(0 2 4 6))
	       (dolist (column '(1 3 5 7))
		       (if (< (aref current-board row column) 0)
			   (if (jump-moves current-board
					   row
					   column
					   'b)
			       (setq moves-flag t)))))
       moves-flag))

;what to do when the black-begin button is pushed
(defun start-black-goes-first()
  (declare (special temp-gadget))
  (let (tmp
	(status-bar (g-value temp-gadget :status-bar)))

       (s-value status-bar :string
		"Initializing game board, please wait...")
       (initialize-board)
       (s-value status-bar :string "Your turn, you go first.")))

;what to do when the white-begin button is pushed
(defun start-white-goes-first()
(declare (special temp-gadget))
  (let (tmp
	(status-bar (g-value temp-gadget :status-bar)))
    (s-value
	status-bar :string
	"Initializing game board and deciding on my move, please wait...")
       (initialize-board)
       (perform-move search-depth)
       (s-value status-bar :string "Your turn.")))

;convert a :box list to (x1 y1 x2 y2) checkers list
(defun convert-box (pixel-list)
  (let ((board_top (g-value temp-gadget :checkerboard :top))
	(board_left (g-value temp-gadget :checkerboard :left)))
    (list (truncate (- (second pixel-list) board_top) square_size)
	  (truncate (- (first pixel-list) board_left) square_size)
	  (truncate (- (fourth pixel-list) board_top) square_size)
	  (truncate (- (third pixel-list) board_left) square_size))))

