Object
	subclass: #Task
	instanceVariableNames: 'dataStack returnStack instructionPointer dataSpace errorStack outputDevice source currentDefinition compiling '
	classVariableNames: 'DataPointer '
	poolDictionaries: 'FORTH '    !


!Task class methods !

dataPointer
	^DataPointer!
 
dataPointer: anInteger
	DataPointer := anInteger!
  
new
    "Create a Task of the default size"
    ^(self new: 1024 returnStack: 1024 dataSpace: 4096)!
  
new:  cellsDataStack returnStack: cellsReturnStack dataSpace: cellsDataSpace
        "create and init a Forth Task instance"
    ^super new
            dataStack: (Stack dataStack: (cellsDataStack max: 1024));
            returnStack: (Stack returnStack: (cellsReturnStack max: 1024));
            dataSpace: (ForthDataSpace cells: (cellsDataSpace max: 4096));
            instructionPointer: nil;
			compiling: false;
            yourself! !



!Task methods !
   
compiling
	^compiling!
 
compiling: aBoolean
	compiling := aBoolean!

currentDefinition
	^currentDefinition!
 
currentDefinition: aColonDefinition
	currentDefinition := aColonDefinition!

dataSpace
        "the task's data space, a ForthDataSpace"
     ^dataSpace!
  
dataSpace: aForthDataSpace
        "the task's data space, a ForthDataSpace"
     ^dataSpace := aForthDataSpace!
  
dataStack
        "the task's data stack"
     ^dataStack!

dataStack: aStack
    dataStack := aStack!
 
errorStack
        "the task's catch .. throw Stack"
     ^errorStack!

errorStack: aStack
	 "the task's catch .. throw Stack"
    errorStack := aStack!
  
forthColon
	| name |
	self compiling ifTrue: [ ^-29 ]. "Compiler nesting THROW"
	self compiling: true.
	(name := self source nextForthWord) = ''
		ifTrue: [ ^-16]	"Attempt to use zero-length string as a name THROW"
		ifFalse: [ self compiling: true.
					currentDefinition := Association key: name asSymbol
					value: (ColonDefinition new immediacy: false; yourself).].
	^0!

forthConstant
	| name |
	self compiling ifTrue: [ ^-29 ]. "Compiler nesting THROW"
    (dataStack size < 1) ifTrue: [ ^-4]. "Stack underflow THROW"
		(name := self source nextForthWord) = ''
		ifTrue: [ ^-16]	"Attempt to use zero-length string as a name THROW"
		ifFalse: [ FORTH at: name asSymbol put: (Constant new: dataStack removeLast)].
	^0!
   
forthCreate
	| name newCreate |
	self compiling ifTrue: [ ^-29 ]. "Compiler nesting THROW"
		(name := self source nextForthWord) = ''
		ifTrue: [ ^-16].	"Attempt to use zero-length string as a name THROW"
		FORTH at: name asSymbol put:
		(newCreate := (CreateDoes new: self) doesBody: (FORTH at: #NOOP); yourself).
		^0!
 
forthDepth
	^dataStack push: dataStack size!
   
forthDot
	| temp |
	(dataStack size > 0) ifFalse: [^-3]. "Data Stack Underflow THROW"
	dataStack last isInteger ifFalse: [ ^-12 ]. "Argument Type Mismatch THROW"
	temp :=  dataStack removeLast.
	temp printOn: outputDevice.
	outputDevice nextPut: $ .
	^0!
   
forthDrop
	^dataStack drop!

forthDup
	^dataStack dup!
  
forthEmit
	| temp |
	(dataStack size > 0) ifFalse: [^-3]. "Data Stack Underflow THROW"
	dataStack last isInteger ifFalse: [ ^-12 ]. "Argument Type Mismatch THROW"
	temp :=  dataStack removeLast.
	outputDevice nextPut: temp asCharacter.
	^0!
  
forthFetch
	| temp |
	(dataStack size > 0) ifFalse: [^-3]. "Data Stack Underflow THROW"
	dataStack last isInteger ifFalse: [ ^-12 ]. "Argument Type Mismatch THROW"
	temp := (dataSpace fetch: dataStack last).
	dataStack at: dataStack size put: temp.
	^0!
 
forthHere
	dataStack push: Task dataPointer.
	^0!
 
forthNoop
	^0!
 
forthOver
	^dataStack over!

forthPause
	^0!

forthRot
	^dataStack rot!
  
forthSemiColon
	self compiling ifFalse: [ ^-14 ].  "interpreting a compile-only word"
	self compiling: false.
	FORTH add: currentDefinition.
	^0!
   
forthStore
	| temp |
	(dataStack size > 1) ifFalse: [^-3]. "Data Stack Underflow THROW"
	dataStack last isInteger ifFalse: [ ^-12 ]. "Argument Type Mismatch THROW"
	dataSpace store: (dataStack at: dataStack size - 1) at: dataStack last .
	dataStack drop; drop.
	^0!
 
forthSwap
	^dataStack swap!

forthVariable
	| name newVar |
	self compiling ifTrue: [ ^-29 ]. "Compiler nesting THROW"
		(name := self source nextForthWord) = ''
		ifTrue: [ ^-16].	"Attempt to use zero-length string as a name THROW"
		(newVar := Variable new: self) isNil ifTrue: [ ^-59 ] "There is no THROW in dpANS5 for Data Space Exhausted"
		ifFalse: [ FORTH at: name asSymbol put: newVar].
	^0!
   
instructionPointer
   ^instructionPointer!
 
instructionPointer: aToken
    instructionPointer := aToken!
   
isCompiling
	"answer true if compiling"
	^self compiling!
 
outputDevice
        "the task's output device, any stream, by default a ForthPane"
     ^outputDevice!
   
outputDevice: aStream
        "the task's output device, any stream, by default a ForthPane"
     outputDevice := aStream!

returnStack
        "the task's return stack"
        ^returnStack!
   
returnStack: aStack
    returnStack := aStack!
 
source
	^source!
   
source: anInputStream
	source := anInputStream! !
