ReadWriteStream
	subclass: #InputStream
	instanceVariableNames: 'task '
	classVariableNames: ''
	poolDictionaries: ''   !


!InputStream class methods !
 
on: aSource forTask: aTask
        "create an input stream on a source"
	^(self on: aSource) task: aTask; yourself.! !



!InputStream methods !
  
forthParse: aChar
        "Answer a String containing the next word in the
         receiver stream delimited by aChar"
    | first |    self atEnd ifTrue: [^''].
    (self next = aChar)
        ifTrue: [ ^((String new: 1) at: 1 put: aChar ; yourself)  ].
        "exit on leading delimiter, advancing position one"
    first := self position.
    [self atEnd
        ifTrue: [^self copyFrom: first to: self position].
        self next = aChar ]
        whileFalse: [].
    self position: self position - 1.
    ^self copyFrom: first to: self position!
  
forthWord: aChar
        "Skip leading delimiters. Answer a String containing
         the next characters in the receiver stream delimited
         by aChar."
        | first |
        [self atEnd ifTrue: [^''].
         self next = aChar ]
        whileTrue: [].
      "skip separators"
       first := self position.
        [self atEnd
         ifTrue: [^self copyFrom: first to: self position].
         self next = aChar ]
         whileFalse: [].
        self position: self position - 1.
       ^self copyFrom: first to: self position!
  
interpret
        "interpret input stream to end ..
		 so far, does not handle numbers
		doesn't advance >IN"
     | w t |
	[(w := self nextForthWord) = '']
	whileFalse:
		[ t := (FORTH at: w asSymbol ifAbsent: [ w isForthNumber
									ifTrue: [ task dataStack push: (w asInteger). FORTH at: #NOOP ]
									 ifFalse: [ task compiling: false. ^ -13]]).
		task compiling ifTrue: [ t isImmediate ifTrue: [t := (t execute: task)]
							     									ifFalse: [
																	task currentDefinition value compileToken: t. t := 0 ]]
								ifFalse: [ t := (t execute: task)].
		(t = 0) ifFalse: [ ^t ]].
	^t
	" -13 is undefined word THROW"!
 
nextForthWord
        "Answer a String containing the next Forth word in the
         receiver stream.  A word is distinguished as a sequence of non-blank
         characters in the InputStream followed by a blank."
     ^(self forthWord: $  )!

task
	^task!
   
task: aTask
	task := aTask! !
