
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "ptg_gen.h"

#if defined(__STDC__) || defined (__cplusplus)
static void _PrPTGNULL(_PPTG0 n)
#else
static void _PrPTGNULL(n)
_PPTG0 n;
#endif
{(void)n; /* function printing nothing */}

struct _SPTG0   _PTGNULL = { _PrPTGNULL };

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOut (PTGNode r)
#else
PTGNode PTGOut (r)
PTGNode r;
#endif
{
  f = stdout;
  if (r) {
     (* (r->_print)) (r);
     fputs("\n", f);
  }
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFile (char *fn, PTGNode r)
#else
PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
#endif
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
	exit(1);
  }
  if (r) {
    (* (r->_print)) (r);
    fputs("\n", f);
  }
  fclose(f);
  return (r);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOutFPtr(FILE *fptr, PTGNode r)
#else
PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
#endif
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
    exit(1);
  }
  if (r) {
    (* (r->_print)) (r);
    fputs("\n", f);
  }
  return (r);
}

typedef struct _SPTG7 *_PPTG7;
struct _SPTG7{
  _PTGProc _print;
  PTGNode _desc [7];
};

typedef struct _SPTG6 *_PPTG6;
struct _SPTG6{
  _PTGProc _print;
  PTGNode _desc [6];
};

typedef struct _SPTG5 *_PPTG5;
struct _SPTG5{
  _PTGProc _print;
  PTGNode _desc [5];
};

typedef struct _SPTG4 *_PPTG4;
struct _SPTG4{
  _PTGProc _print;
  PTGNode _desc [4];
};

typedef struct _SPTG3 *_PPTG3;
struct _SPTG3{
  _PTGProc _print;
  PTGNode _desc [3];
};

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGIdentifier *_PPTGIdentifier;
struct _SPTGIdentifier{
  _PTGProc _print;
  int _t0;
};

typedef struct _SPTGString *_PPTGString;
struct _SPTGString{
  _PTGProc _print;
  char *_t0;
};

typedef struct _SPTGNum *_PPTGNum;
struct _SPTGNum{
  _PTGProc _print;
  int _t0;
};

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGCGen(_PPTG1 n)
#else
static void _PrPTGCGen(n)
_PPTG1 n;
#endif
{
  fputs ("#include \"deftbl.h\"\n", f);
  fputs ("#include \"pdl_gen.h\"\n\n", f);
  fputs ("#define PRESENT find(key, _Property, &_Item, 0)\n", f);
  fputs ("#define VALUE (_Item->PropVal)\n\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGOperationSpec(_PPTG7 n)
#else
static void _PrPTGOperationSpec(n)
_PPTG7 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("(_Property, ", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs (")\n", f);
  fputs ("int _Property;\n", f);
  (* (n->_desc [4]->_print))(n->_desc[4]);
  fputs ("{  ", f);
  (* (n->_desc [5]->_print))(n->_desc[5]);
  fputs ("Property _Item;\n", f);
  (* (n->_desc [6]->_print))(n->_desc[6]);
  fputs ("\n}\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGParen(_PPTG1 n)
#else
static void _PrPTGParen(n)
_PPTG1 n;
#endif
{
  fputs ("(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

#if defined(__STDC__) || defined(__cplusplus)
extern void PrIdent(FILE *, int);
#else
extern void PrIdent();
#endif

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGIdentifier(_PPTGIdentifier n)
#else
static void _PrPTGIdentifier(n)
_PPTGIdentifier n;
#endif
{
  PrIdent(f,n->_t0);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGString(_PPTGString n)
#else
static void _PrPTGString(n)
_PPTGString n;
#endif
{
  fprintf (f, "%s",n->_t0);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGCommaSeq(_PPTG2 n)
#else
static void _PrPTGCommaSeq(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (", ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGParamDecl(_PPTG3 n)
#else
static void _PrPTGParamDecl(n)
_PPTG3 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs (";\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSModifier(_PPTG1 n)
#else
static void _PrPTGSModifier(n)
_PPTG1 n;
#endif
{
  fputs ("(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGEModifier(_PPTG1 n)
#else
static void _PrPTGEModifier(n)
_PPTG1 n;
#endif
{
  fputs ("(", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (", ... )", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGPTypeSpec(_PPTG2 n)
#else
static void _PrPTGPTypeSpec(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGIPTypeSpec(_PPTG3 n)
#else
static void _PrPTGIPTypeSpec(n)
_PPTG3 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs (" ", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGFuncName(_PPTG1 n)
#else
static void _PrPTGFuncName(n)
_PPTG1 n;
#endif
{
  fputs ("(*", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (")", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGSeq(_PPTG2 n)
#else
static void _PrPTGSeq(n)
_PPTG2 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGTypeDef(_PPTG3 n)
#else
static void _PrPTGTypeDef(n)
_PPTG3 n;
#endif
{
  fputs ("typedef struct ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("Elt {\n", f);
  fputs ("\tstruct ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("Elt *next;\n", f);
  fputs ("\tint selector;\n", f);
  fputs ("\tTYPE PropVal;\n", f);
  fputs ("} *", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("Property;\n\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGFunctions(_PPTG3 n)
#else
static void _PrPTGFunctions(n)
_PPTG3 n;
#endif
{
  fputs ("#define TYPE ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n\n", f);
  fputs ("#define ACCESS find(key, _Property, &_Item, sizeof(struct ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("Elt))\n\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("#undef ACCESS\n", f);
  fputs ("#undef TYPE\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGHGen(_PPTG3 n)
#else
static void _PrPTGHGen(n)
_PPTG3 n;
#endif
{
  fputs ("#ifndef PDL_GEN_H\n", f);
  fputs ("#define PDL_GEN_H\n\n", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n", f);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("\n", f);
  fputs ("#endif\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGInclude(_PPTG1 n)
#else
static void _PrPTGInclude(n)
_PPTG1 n;
#endif
{
  fputs ("#include \"", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\"\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGExternSpec(_PPTG4 n)
#else
static void _PrPTGExternSpec(n)
_PPTG4 n;
#endif
{
  fputs ("extern ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("(/* int _Property; ", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  fputs ("*/);\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGExtParamDecl(_PPTG3 n)
#else
static void _PrPTGExtParamDecl(n)
_PPTG3 n;
#endif
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("; ", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGExterns(_PPTG2 n)
#else
static void _PrPTGExterns(n)
_PPTG2 n;
#endif
{
  fputs ("#define TYPE ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("#undef TYPE\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGMacro(_PPTG7 n)
#else
static void _PrPTGMacro(n)
_PPTG7 n;
#endif
{
  fputs ("#define ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  (* (n->_desc [2]->_print))(n->_desc[2]);
  fputs ("   \\\n", f);
  fputs ("\t\t", f);
  (* (n->_desc [3]->_print))(n->_desc[3]);
  (* (n->_desc [4]->_print))(n->_desc[4]);
  fputs ("(", f);
  (* (n->_desc [5]->_print))(n->_desc[5]);
  fputs (", ", f);
  (* (n->_desc [6]->_print))(n->_desc[6]);
  fputs (")\n", f);
}

#if defined (__STDC__) || defined(__cplusplus)
static void _PrPTGNum(_PPTGNum n)
#else
static void _PrPTGNum(n)
_PPTGNum n;
#endif
{
  fprintf (f, "%d",n->_t0);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGCGen(PTGNode _t0)
#else
PTGNode PTGCGen(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGCGen;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGOperationSpec(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3,PTGNode _t4,PTGNode _t5,PTGNode _t6)
#else
PTGNode PTGOperationSpec(_t0,_t1,_t2,_t3,_t4,_t5,_t6)
PTGNode _t0,_t1,_t2,_t3,_t4,_t5,_t6;
#endif
{
  _PPTG7 n;

  if ((n = (_PPTG7) malloc (sizeof (struct _SPTG7)))  ==  (_PPTG7)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGOperationSpec;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  n->_desc[4]=_t4;
  n->_desc[5]=_t5;
  n->_desc[6]=_t6;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGParen(PTGNode _t0)
#else
PTGNode PTGParen(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGParen;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGIdentifier(int _t0)
#else
PTGNode PTGIdentifier(_t0)
  int _t0;
#endif
{
  _PPTGIdentifier n;

  if ((n = (_PPTGIdentifier) malloc (sizeof (struct _SPTGIdentifier)))  ==  (_PPTGIdentifier)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGIdentifier;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGString(char *_t0)
#else
PTGNode PTGString(_t0)
  char *_t0;
#endif
{
  _PPTGString n;

  if ((n = (_PPTGString) malloc (sizeof (struct _SPTGString)))  ==  (_PPTGString)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGString;
  n->_t0=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGCommaSeq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGCommaSeq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGCommaSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGParamDecl(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGParamDecl(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGParamDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSModifier(PTGNode _t0)
#else
PTGNode PTGSModifier(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSModifier;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGEModifier(PTGNode _t0)
#else
PTGNode PTGEModifier(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGEModifier;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGPTypeSpec(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGPTypeSpec(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGPTypeSpec;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGIPTypeSpec(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGIPTypeSpec(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGIPTypeSpec;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGFuncName(PTGNode _t0)
#else
PTGNode PTGFuncName(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGFuncName;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGSeq(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGTypeDef(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGTypeDef(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGTypeDef;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGFunctions(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGFunctions(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGFunctions;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGHGen(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGHGen(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGHGen;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGInclude(PTGNode _t0)
#else
PTGNode PTGInclude(_t0)
PTGNode _t0;
#endif
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGInclude;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGExternSpec(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3)
#else
PTGNode PTGExternSpec(_t0,_t1,_t2,_t3)
PTGNode _t0,_t1,_t2,_t3;
#endif
{
  _PPTG4 n;

  if ((n = (_PPTG4) malloc (sizeof (struct _SPTG4)))  ==  (_PPTG4)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGExternSpec;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGExtParamDecl(PTGNode _t0,PTGNode _t1,PTGNode _t2)
#else
PTGNode PTGExtParamDecl(_t0,_t1,_t2)
PTGNode _t0,_t1,_t2;
#endif
{
  _PPTG3 n;

  if ((n = (_PPTG3) malloc (sizeof (struct _SPTG3)))  ==  (_PPTG3)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGExtParamDecl;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGExterns(PTGNode _t0,PTGNode _t1)
#else
PTGNode PTGExterns(_t0,_t1)
PTGNode _t0,_t1;
#endif
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGExterns;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGMacro(PTGNode _t0,PTGNode _t1,PTGNode _t2,PTGNode _t3,PTGNode _t4,PTGNode _t5,PTGNode _t6)
#else
PTGNode PTGMacro(_t0,_t1,_t2,_t3,_t4,_t5,_t6)
PTGNode _t0,_t1,_t2,_t3,_t4,_t5,_t6;
#endif
{
  _PPTG7 n;

  if ((n = (_PPTG7) malloc (sizeof (struct _SPTG7)))  ==  (_PPTG7)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGMacro;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  n->_desc[2]=_t2;
  n->_desc[3]=_t3;
  n->_desc[4]=_t4;
  n->_desc[5]=_t5;
  n->_desc[6]=_t6;
  return ((PTGNode) n);
}

#if defined(__STDC__) || defined(__cplusplus)
PTGNode PTGNum(int _t0)
#else
PTGNode PTGNum(_t0)
  int _t0;
#endif
{
  _PPTGNum n;

  if ((n = (_PPTGNum) malloc (sizeof (struct _SPTGNum)))  ==  (_PPTGNum)NULL)
	MEMERR
  n->_print = (_PTGProc) _PrPTGNum;
  n->_t0=_t0;
  return ((PTGNode) n);
}


