static char RCSid[] = "$Id: envmod.c,v 1.12 1992/04/28 16:48:59 waite Exp $";
/* Copyright 1991, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#include <malloc.h>
#include "err.h"
#include "envmod.h"

static StkPtr FreeStackElements = (StkPtr)0;

/**/
static StkPtr
NewStkElt()
/* Obtain a new definition stack element
 *    On exit-
 *       NewStkElt popints to an element with undefined contents
 **/
{
   StkPtr tmp;

   if (FreeStackElements) {
      tmp = FreeStackElements; FreeStackElements = FreeStackElements->out; 
   } else if (!(tmp = (StkPtr)malloc(sizeof(struct StkElt))))
         message(DEADLY, "NewStkElt: malloc failed", 0, (POSITION *)0);
   return tmp;
}

/***/
Environment
NewEnv()
/* Establish a new environment
 *    On exit-
 *       NewEnv=new environment
 ***/
{
   Environment e; int k;

   e = (Environment)malloc(sizeof(struct EnvImpl));
   if (!e) message(DEADLY, "NewEnv: malloc failed", 0, (POSITION *)0);
   e->relate = (Scope)0; e->parent = (Environment)0;
   e->nested = (Access)malloc(sizeof(struct AccessMechanism)); 
   for (k = 0; k < MaxIdn; k++)
      e->nested->IdnTbl[k] = (StkPtr)0;
   e->nested->CurrEnv = e;
   return e;
}

/**/
#if defined(__cplusplus) || defined(__STDC__)
static void
EnterEnv(Environment env)
#else
static void
EnterEnv(env)
Environment env;
#endif
/* Make the state of the array reflect env
 *    On entry-
 *       The nested of the array reflects the parent of env
 **/
{
   Scope r; StkPtr s;

   r = env->relate;
   env->nested = env->parent->nested;
   while (r) {
      s = NewStkElt();
      s->env = env; s->key = r->key;
      s->out = env->nested->IdnTbl[r->idn]; env->nested->IdnTbl[r->idn] = s;
      r = r->nxt;
   }
   env->nested->CurrEnv = env;
}
 
/**/
#if defined(__cplusplus) || defined(__STDC__)
static void
LeaveEnv(Environment env)
#else
static void
LeaveEnv(env)
Environment env;
#endif
/* Make the nested of the array reflect the parent of env
 *    On entry-
 *       The nested of the array reflects env
 **/
{
   Scope r; StkPtr s;

   r = env->relate;
   while (r) {
      s = env->nested->IdnTbl[r->idn]; env->nested->IdnTbl[r->idn] = s->out;
      s->out = FreeStackElements; FreeStackElements = s;
      r = r->nxt;
   }
   env->nested->CurrEnv = env->parent;
   env->nested = (Access)0;
}
 
/***/
#if defined(__cplusplus) || defined(__STDC__)
void
SetEnv(Environment env)
#else
void
SetEnv(env)
Environment env;
#endif
/* Make certain that the nested of the array reflects env
 ***/
{
   if (env) {
      if (env->nested) {
         while (env->nested->CurrEnv != env) LeaveEnv(env->nested->CurrEnv);
      } else {
         SetEnv(env->parent); EnterEnv(env);
      }
   }
}
 
/***/
#if defined(__cplusplus) || defined(__STDC__)
Environment
NewScope(Environment env)
#else
Environment
NewScope(env)
Environment env;
#endif
/* Establish a new scope within an environment
 *    On exit-
 *       NewScope=new environment that is a child of env
 ***/
{
   Environment e;
 
   if (!env) return NoEnv;
   e = (Environment)malloc(sizeof(struct EnvImpl));
   e->relate = (Scope)0; e->parent = env; e->nested = (Access)0;
   return e;
}
 
/***/
#if defined(__cplusplus) || defined(__STDC__)
int
AddIdn(Environment env, int idn, DefTableKey key)
#else
int
AddIdn(env, idn, key)
Environment env; int idn; DefTableKey key;
#endif
/* Add an identifier definition to a scope
 *    If idn is defined in env then on exit-
 *       AddIdn=0
 *    Else on exit-
 *       idn is defined in env with the key key
 *       AddIdn=1
 ***/
{
   Scope r; StkPtr s;

   if (!env) return 0;
   SetEnv(env);

   if (idn >= MaxIdn)
      message(DEADLY, "AddIdn: Too many identifiers", 0, (POSITION *)0);

   if (env->nested->IdnTbl[idn] ? env->nested->IdnTbl[idn]->env==env : 0)
      return 0;
   else {
      r = (Scope)malloc(sizeof(struct RelElt));
      r->idn = idn; r->key = key; r->nxt = env->relate; env->relate = r;
      s = NewStkElt(); s->env = env; s->key = key;
      s->out = env->nested->IdnTbl[idn]; env->nested->IdnTbl[idn] = s;
      return 1;
   }
}

/***/
#if defined(__cplusplus) || defined(__STDC__)
DefTableKey
DefineIdn(Environment env, int idn)
#else
DefTableKey
DefineIdn(env, idn)
Environment env; int idn;
#endif
/* Define an identifier in a scope
 *    If idn is defined in env then on exit-
 *       DefineIdn=key for idn in env
 *    Else let n be a previously-unused definition table key
 *    Then on exit-
 *       DefineIdn=n
 *       idn is defined in env with the key n
 ***/
{
   DefTableKey p; Scope r; StkPtr s;

   if (!env) return NoKey;
   SetEnv(env);

   if (idn >= MaxIdn)
      message(DEADLY, "DefineIdn: Too many identifiers", 0, (POSITION *)0);

   if (env->nested->IdnTbl[idn] ? env->nested->IdnTbl[idn]->env==env : 0)
      return env->nested->IdnTbl[idn]->key;
   else {
      p = NewKey();
      r = (Scope)malloc(sizeof(struct RelElt));
      r->idn = idn; r->key = p; r->nxt = env->relate; env->relate = r;
      s = NewStkElt(); s->env = env; s->key = p;
      s->out = env->nested->IdnTbl[idn]; env->nested->IdnTbl[idn] = s;
      return p;
   }
}

/***/
#if defined(__cplusplus) || defined(__STDC__)
DefTableKey
KeyInEnv(Environment env, int idn)
#else
DefTableKey
KeyInEnv(env, idn)
Environment env; int idn;
#endif
/* Find the key for an identifier in an environment
 *    If idn is defined in env then on exit-
 *       KeyInEnv=key for idn in env
 *    Else if idn is defined in some ancestor of env then on exit-   
 *       KeyInEnv=KeyInEnv(Parent(env),idn)
 *    Else on exit-
 *       KeyInEnv=key that represents no definition
 ***/
{
   if (!env) return NoKey;
   SetEnv(env);

   if (idn >= MaxIdn)
      message(DEADLY, "KeyInEnv: Too many identifiers", 0, (POSITION *)0);

   return (env->nested->IdnTbl[idn] ? env->nested->IdnTbl[idn]->key : NoKey);
}

/***/
#if defined(__cplusplus) || defined(__STDC__)
DefTableKey
KeyInScope(Environment env, int idn)
#else
DefTableKey
KeyInScope(env, idn)
Environment env; int idn;
#endif
/* Find the key for an identifier in a scope
 *    If idn is defined in env then on exit-   
 *       KeyInScope=key for idn in env
 *    Else on exit- 
 *       KeyInScope=key that represents no definition
 ***/
{
   Scope r;

   if (env) {
      for (r = env->relate; r; r = r->nxt)
         if (r->idn == idn) return r->key;
   }
   return NoKey;
}
