static char RCSid[] = "$Id: CchStr.c,v 1.13 1993/02/13 04:30:06 waite Exp $";
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

/*
 * scan and process C char constants and char strings
 * Updated to handle long, multi-line strings.  See gla.impl paper for info.
 */

#include "err.h"
#include "source.h"
#include "gla.h"

extern char* malloc();
static char * DynamicStart = 0;
static char * DynamicEnd   = 0;
#define DYNAMICSIZE 2048	/* handle strings up to this length */
#define BKSLASH '\\'
#define SQ	'\''

/*
** If arbitrary length strings are used, then BOTH
** auxCString and c_mkstr MUST be used.  The following
** variable checks this.
*/
static char CompanionWasNotCalled = 0;

/*
 * auxCString
 *
 * Scan a string literal after the opening double quote.
 *
 * On entry, start points to the opening quote, len should be 1.
 * On exit, we return the position after the closing quote.
 */

char *auxCString( start, len )
char *start;	/* used subtly - see below */
int len;
{
        register char c ;
        register char *p = start + len;
	int escape = 0;

newbuf:	if (escape) {
		if((c = *p++) == '\n') {
			LineNum++;
			StartLine = p - 1;
			}
		}
		
	/* three possible conditions can stop the loop */
top:	while( (c = *p++) && c != '"' && c != '\\' && c != '\n' )
		;

	if(c == '"'){
		if(DynamicStart<DynamicEnd){/* copy rest of multi-line*/

		    if(CompanionWasNotCalled)	/* assertion check */
		        message(FATAL, 
			"auxCString + c_mkstr must be used as a pair",0,
			&curpos);
		    CompanionWasNotCalled++;  /* c_mkstr must clear it*/

		    if(DynamicEnd-DynamicStart + p-start > DYNAMICSIZE){
			message(FATAL,
			"multi-line string too long", 0, &curpos);
			return p;
			}

		    while(start < p)
			*DynamicEnd++ = *start++;
		    }
		return(p);	/* normal string ending */
		} /* " */

	else if(c == '\\') {
		if((c = *p++) == '\n') {
			LineNum++;
			StartLine = p - 1;
			}
		else if(c == '\0') {
			p--;
			escape = 1;
			}
		goto top;
		}

	else if(c == '\n') {
		LineNum++;
		StartLine = p - 1;
		message(ERROR, "illegal newline in string literal", 0, &curpos);
		return p;
		}


	/*
	** We hit EOB or EOF and still have not finished finding string -
	** prepare for dynamic memory.
	*/
	else /* if (c == '\0') */ {
		/* if memory doesnt exist, get it */
		if(DynamicStart==0){
			DynamicStart = DynamicEnd = malloc(DYNAMICSIZE);
			if(DynamicStart == 0)
			  message(FATAL, "No mem for auxCString", 0,&curpos);
			}

		/* copy from source buffer to dynamic mem */
		/*  amt used so far        + new amt > total avail amt */
		if(DynamicEnd-DynamicStart + p-start > DYNAMICSIZE){
		  message(FATAL,"out of mem for multi-line string", 0, &curpos);
		  return p;
		  }
		while(start < p-1)
			*DynamicEnd++ = *start++;

		refillBuf( p-1 );
		start = p = TokenEnd; /* reset start so next copy will work */
		if (*p == '\0') {
			message(ERROR,"file ends in literal string",0,&curpos);
			return p-1;
			}
		else
			goto newbuf;	/* continue scanning string */
        }/*end else*/
}/*auxCString*/


static int CharValue;	/* global to hold value of escape sequence */


char *		/* return prt to char beyond escape sequence */
readescape (p)
char * p;	/* points to first char past BKSLASH */
{
  register int c = *p++;
  register int count;

  switch (CharValue = c)	/* assume simple escape like " or ' */
    {
/* HEX */
    case 'x':
      CharValue = 0;
      count = 0;
      while (1)
	{
	  c = *p++;
	  if (!(c >= 'a' && c <= 'f') && !(c >= 'A' && c <= 'F')
	      && !(c >= '0' && c <= '9')) {
	      p--;
	      break;
	      }
	  CharValue *= 16;
	  if (c >= 'a' && c <= 'f')
	    CharValue += c - 'a' + 10;
	  if (c >= 'A' && c <= 'F')
	    CharValue += c - 'A' + 10;
	  if (c >= '0' && c <= '9')
	    CharValue += c - '0';
	  count++;
	}
      if (count == 0)
	message (ERROR, "\\x used with no following hex digits",0,&curpos);
      return p;

/* OCTAL */
    case '0':  case '1':  case '2':  case '3':  case '4':
    case '5':  case '6':  case '7':
      CharValue = 0;
      count = 0;
      while ((c <= '7') && (c >= '0') && (count++ < 3))
	{
	  CharValue = (CharValue * 8) + (c - '0');
	  c = *p++;
	}
      p--;
      return p;

/* MISC */
    case '\n': case BKSLASH: case SQ: case '"': case '?':
      return p;

/* CONTROL */
    case 'a': CharValue = '\007'; return p;
    case 'n': CharValue = '\n'; return p;
    case 't': CharValue = '\t'; return p;
    case 'r': CharValue = '\r'; return p;
    case 'f': CharValue = '\f'; return p;
    case 'b': CharValue = '\b'; return p;
    case 'v': CharValue = '\v'; return p;

    } /* end switch */

  if (c >= 040 && c <= 0177)
    message(NOTE,"unknown escape sequence",0, &curpos);
  else
    message(ERROR,"unknown escape sequence: `\\' followed by char",0,&curpos);
  return p;
}
        
/*
 * c_mkstr
 *
 * Make an internal string value from a character string by
 * colapsing escape sequences.
 *
 * On entry, c points to a character string of length 
 *           t points to a location containing the initial terminal code
 * On exit, t points to a location containing the correct terminal code
 *          an internal string value representing the character string has been
 *          stored at the location pointed to by v.
 */

void c_mkstr(c, length, t, v)
char *c;
int length, *t;
char *v;
{
        char *from , *to, *tmp;
	char converted[DYNAMICSIZE];	/* converted string */

	CompanionWasNotCalled = 0;	/* reset for auxCString */

	if (DynamicStart < DynamicEnd) {	/* difficult strings */

		/* overRide some stuff, BACKDOOR method !!! */
		c = DynamicStart;
		length = DynamicEnd-DynamicStart;
		DynamicEnd = DynamicStart;	/* reset back to normal */
		}

	from = c;
	to = &converted[0];

        from++; /* skip leading quote */
        length -= 2; /* throw away both quotes */
        for (; (length> 0);){
		if( *from == BKSLASH){
			if( *(from+1) == '\n' ) {
				length -= 2;	/* throw away escaped NLs */
				from += 2;
				}
			else	{
                        	tmp = readescape( from+1);
				*to++ = CharValue;
				length -= tmp - from;
				from = tmp;
				}
			}
		else	{
                        *to++ = *from++;
                        length--;
			}
                }/*endfor*/

        mkstr( converted, to-converted, t, v ); /* save the string */
}


/*
 * auxCChar
 *
 * Scan a character literal after the opening single quote.
 *
 * On entry, start points to the opening quote, len should be 1.
 * On exit, we return the position after the closing quote.
 */

char *auxCChar( start, len )
char *start;
int len;
{
	register char c;
	register char *p = start + len;

	if( (c= *p++) == BKSLASH){
		p++;	/* this char cannot terminate quote so skip it
			** because if it were SQ, the while loop would stop
			*/

		/* look for terminating SQ */
		while( (c = *p++) && c != SQ && c != '\n')
			;
		if(c == SQ)
			return(p);	/* normal char constant */

		message(ERROR, "newline or EOF in char quote", 0, &curpos);
		return(p-1); /* backup so NL or EOF will be processed */
		}
	else	{
		if(c == '\n') {
		    message(ERROR, "newline in char quote", 0, &curpos);
		    return(p-1);
		    }
		if(c == SQ) {
		    message(ERROR, "quote in char quote", 0, &curpos);
		    return(p);
		    }
		if( *p++ != SQ)
		    message(ERROR, "illformed char quote", 0, &curpos);
		return(p);
		}

}


/*
 * c_mkchar
 *
 * On entry, c points to a character string of length l
 *           t points to the initial terminal code (not used)
 * On exit, 
 *          The location v contains the value of the character literal.
 */

void c_mkchar(c, l, t, v)
char *c;
int l, *t;
int *v;
{
	char * tmp;
	c++;		/* skip leading single quote (')  */

	if(*c == BKSLASH){
		tmp = readescape(c+1);
		if( *tmp != SQ)
		     message(ERROR,"malformed character constant", 0,&curpos);
		*v = CharValue;
		}
	else
		*v = (int) *c;
}
