/* $Id: source.h,v 1.10 1993/01/03 18:21:33 waite Exp $ */
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#ifndef SOURCE_H
#define SOURCE_H

extern char SourceName[];	/* to remember the name of the source file */
extern int LineNum;		/* in source file */
extern char *TokenEnd;		/* current pos in buffer, also marks tokenend */
extern char *TokenStart;	/* mark start of a token */
extern char *StartLine;		/* used to calculate column position */

#if defined(__cplusplus) || defined(__STDC__)

extern void initBuf(const char *infile, int f);
/* Initialize the source text module
 *   On entry-
 *     infile is the symbolic name of the input file
 *     f is the descriptor for the input file
 *     The input file has been opened successfully
 *   If the input file is empty then on exit-
 *     TokenEnd points to a NUL character
 *   Otherwise on exit-
 *     An integral number of lines of the input file, including their
 *       terminating newline characters, occupy successive character positions
 *       in memory starting with the location pointed to by TokenEnd.
 *     If the file contains no newline, one is supplied after the last
 *       character of the file.
 *     The character position after the terminating newline of the last
 *       line contains a NUL character
 ***/

extern void refillBuf(char *p);
/* Obtain additional information from the input file
 *   On entry-
 *     p addresses a NUL following the terminating newline of the last
 *       line currently in memory
 *   If there is no more information in the input file then on exit-
 *     TokenEnd points to a NUL character
 *   Otherwise on exit- 
 *     An integral number of lines of the input file, including their
 *       terminating newline characters, occupy successive character positions
 *       in memory starting with the location pointed to by TokenEnd.
 *     If the file contains no newline, one is supplied after the last
 *       character of the file.
 *     The character position after the terminating newline of the last
 *       line contains a NUL character 
 ***/

#else
extern void refillBuf();
extern void initBuf();
#endif

#endif
