/* Test class KeySortCltn

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	keysortcltn.c,v $
 * Revision 2.204  89/10/07  23:50:45  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  14:51:19  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:22:28  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.1  89/05/11  22:24:54  keith
 * Update for R2.0.
 * 
*/
static char rcsid[] = "$Header: keysortcltn.c,v 2.204 89/10/07 23:50:45 keith Stab $";

#include "KeySortCltn.h"
#include "String.h"
#include "Date.h"
#include "Float.h"
#include "Time.h"
#include "Integer.h"

KeySortCltn c;

static void part1()
{
	c.addAssoc(*new String("A"),*new String("Ant"));
	c.addAssoc(*new String("M"),*new String("Man"));
	c.addAssoc(*new String("C"),*new String("Cat"));
	c.addAssoc(*new String("E"),*new String("Emu"));
	c.addAssoc(*new String("H"),*new Date(25,"Dec",85));
	c.addAssoc(*new String("J"),*new Float(98.6));
	c.addAssoc(*new String("E"),*new String("Eeyore"));
	c.addAssoc(*new String("Z"),*new Time(Date(29,"Jan",63),21,30));

	c.printOn(cout); cout << endl;

	int k;
	k = c.findIndexOf(String("A"));
	cout << form("index %d before key %s\n",k,"A");
	k = c.findIndexOf(String("M"));
	cout << form("index %d before key %s\n",k,"M");
	k = c.findIndexOf(String("C"));
	cout << form("index %d before key %s\n",k,"C");
	k = c.findIndexOf(String("E"));
	cout << form("index %d before key %s\n",k,"E");
	k = c.findIndexOf(String("Z"));
	cout << form("index %d before key %s\n",k,"Z");
	k = c.findIndexOf(String("F"));
	cout << form("index %d before key %s\n",k,"F");
	k = c.findIndexOf(String("@"));
	cout << form("index %d before key %s\n",k,"@");
	k = c.findIndexOf(String("["));
	cout << form("index %d before key %s\n",k,"[");

	KeySortCltn clone = *KeySortCltn::castdown(c.copy());
	cout << form("clone isEqual c: %d\n", c.isEqual(clone));
	cout << form("clone == c: %d\n", c == (clone));
	cout << form("clone != c: %d\n", c != (clone));
	cout << form("c.compare(clone) = %d\n", c.compare(clone));
	cout << form("c.includesKey(String(\"J\")) = %d\n", c.includesKey(String("J")));
	cout << form("c.includesKey(String(\"K\")) = %d\n", c.includesKey(String("K")));
	cout << form("c.occurrencesOfKey(String(\"Q\")) = %d\n", c.occurrencesOfKey(String("Q")));
	cout << form("c.occurrencesOfKey(String(\"M\")) = %d\n", c.occurrencesOfKey(String("M")));
	cout << form("c.occurrencesOfKey(String(\"E\")) = %d\n", c.occurrencesOfKey(String("E")));

	cout << "atKey(String(\"J\")) = " << *c.atKey(String("J"))
	     << endl;
	cout << "atKey(String(\"N\")) = " << *c.atKey(String("N"))
	     << endl;
}

static void part2()
{
	OrderedCltn o;
	c.addValuesTo(o);
	c.addKeysTo(o);
	cout << "\nOrderedCltn o =\n";
	cout << o << endl;

	SortedCltn b;
	c.addContentsBeforeTo(String("E"), b);
	cout << "\nSortedCltn b =\n";
	cout << b << endl;

	cout << "*c.removeKey(String(\"Z\")) = " << *c.removeKey(String("Z")) << endl;
	cout << "*c.removeKey(String(\"Q\")) = " << *c.removeKey(String("Q")) << endl;
	cout << "*c.removeKey(String(\"E\")) = " << *c.removeKey(String("E")) << endl;
	c.printOn(cout); cout << endl;

	const int ARRAY_SIZE = 4;
	ArrayOb x(ARRAY_SIZE), y(ARRAY_SIZE), z(ARRAY_SIZE);
	String s0("apple"), s1("bat"), s2("cat");
	String s3("gopher"), s4("dog"), s5("eagle");

	int i;
	for (i = 0; i < ARRAY_SIZE - 1; i++)
		switch (i) {
			case (0):
				x[i] = y[i] = z[i] = &s0;
				break;
			case (1):
				x[i] = y[i] = z[i] = &s1;
				break;
			case (2):
				x[i] = y[i] = z[i] = &s2;
				break;
		} /* switch */

	x[ARRAY_SIZE - 1] = &s3;
	y[ARRAY_SIZE - 1] = &s4;
	z[ARRAY_SIZE - 1] = &s5;

	KeySortCltn d;

	d.addAssoc(x, Integer(0));
	d.addAssoc(y, Integer(1));
	d.addAssoc(z, Integer(2));
	cout << endl; d.printOn(cout); cout << endl;
	int k;
	k = d.findIndexOf(y);
	cout << "index "; y.printOn(cout); cout << form("\nbefore key %d\n", k);
}

main()
{
	cout << "\nTest class KeySortCltn\n";
	part1();
	part2();
}
