/* Stack.c -- implementation of class Stack

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	October, 1985

Function:
	
Member function definitions for class Stack.

$Log:	Stack.c,v $
 * Revision 2.204  89/10/07  23:21:48  keith
 * Pre-release
 * 
 * Revision 2.203.1.1  89/09/09  20:09:53  keith
 * Eliminate isEqual() and species().
 * 
 * Revision 2.203  89/08/08  15:24:33  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/08  19:13:03  keith
 * Add initialization of virtual base Object to readFrom() constructors
 * 
 * Revision 2.202.1.1  89/07/01  21:56:15  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:56:15  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:17:46  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/21  12:52:11  keith
 * Add explicit base class names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/05/25  09:57:08  ted
 * Changed casts to call castdown.
 * 
 * Revision 2.201  89/05/12  11:20:37  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.4  89/05/12  11:02:02  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.3  89/05/05  10:00:04  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.2  89/05/03  23:10:34  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:18:51  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:31:36  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:09:43  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Stack.h"
#include "nihclIO.h"

#define	THIS	Stack
#define	BASE	SeqCltn
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES OrderedCltn::desc()
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(Stack,2,"$Header: Stack.c,v 2.204 89/10/07 23:21:48 keith Stab $",NULL,NULL);

Stack::Stack(unsigned size) : contents(size) {}

Object* Stack::add(Object& ob)	{ return contents.add(ob); }

Object*& Stack::at(int i)			{ return contents.at(size()-i-1); }

const Object *const& Stack::at(int i) const	{ return contents.at(size()-i-1); }

unsigned Stack::capacity() const	{ return contents.capacity(); }

void Stack::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	contents.deepenShallowCopy();
}

unsigned Stack::hash() const		{ return contents.hash(); }

bool Stack::isEmpty() const		{ return contents.size()==0; }

Object* Stack::last() const		{ return contents.last(); }

void Stack::reSize(unsigned newSize) { contents.reSize(newSize); }

void Stack::removeAll()
{
	contents.removeAll();
}

Object* Stack::removeLast()	{ return contents.removeLast(); }

unsigned Stack::size() const		{ return contents.size(); }

Stack::Stack(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm),
	contents(strm)
{
}

void Stack::storer(OIOout& strm) const
{
	BASE::storer(strm);
	contents.storeMemberOn(strm);
}

Stack::Stack(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd),
	contents(fd)
{
}

void Stack::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	contents.storeMemberOn(fd);
}

void Stack::atAllPut(Object&)	{ shouldNotImplement("atAllPut"); }

int Stack::indexOfSubCollection(const SeqCltn& /* cltn */, int /* start */) const
{
	shouldNotImplement("indexOfSubCollection");
	return 0;
}

Object* Stack::remove(const Object&)
{
	shouldNotImplement("remove");
	return 0;
}

void Stack::replaceFrom(int /* start */, int /* stop */, const SeqCltn&  /* replacement */, int /* startAt */)
{
	shouldNotImplement("replaceFrom");
}
