#ifndef	SHAREDQUEUE_H
#define	SHAREDQUEUE_H

/*$Header: SharedQueue.h,v 2.204 89/10/07 23:21:40 keith Stab $*/

/* SharedQueue.h -- declarations for shared queues

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	SharedQueue.h,v $
 * Revision 2.204  89/10/07  23:21:40  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:24:27  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/01  23:44:09  keith
 * Add copy constructors to fix yacc stack overflows
 * 
 * Revision 2.202.1.1  89/07/01  21:56:08  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:56:09  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:17:33  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:17:30  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:45:52  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:20:30  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  11:01:54  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:10:26  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:18:37  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:31:29  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:09:31  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "ArrayOb.h"
#include "Semaphore.h"

class SharedQueue: public VIRTUAL Object {
	DECLARE_MEMBERS(SharedQueue);
	ArrayOb queue;
	int readPosition,writePosition;
	Semaphore valueAvailable;
	Semaphore spaceAvailable;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	SharedQueue(unsigned queueSize =Collection::DEFAULT_CAPACITY);
#ifndef BUG_TOOBIG
// yacc stack overflow
	SharedQueue(const SharedQueue&);
#endif
	bool isFull() const	{ return spaceAvailable.value() == 0; }
	virtual unsigned capacity() const;
	virtual Object* copy() const;	// deepCopy()
	virtual void deepenShallowCopy();
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned hash() const;
	virtual bool isEmpty() const;
	virtual bool isEqual(const Object&) const;
	virtual Object* next();
	virtual Object* nextPut(Object&);
	virtual void printOn(ostream& strm =cout) const;
	virtual unsigned size() const;
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
