#ifndef	SEMAPHORE_H
#define	SEMAPHORE_H

/*$Header: Semaphore.h,v 2.204 89/10/07 23:21:29 keith Stab $*/

/* Semaphore.h -- declarations for Semaphore

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Semaphore.h,v $
 * Revision 2.204  89/10/07  23:21:29  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:24:12  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/01  23:44:04  keith
 * Add copy constructors to fix yacc stack overflows
 * 
 * Revision 2.202.1.1  89/07/01  21:55:55  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:55:55  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:17:08  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:17:21  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:44:02  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:20:16  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  11:01:21  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:10:09  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:18:10  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:31:13  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:09:05  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 */

#include "Object.h"
#include "LinkedList.h"

class Process;

class Semaphore: public VIRTUAL Object {
	DECLARE_MEMBERS(Semaphore);
	LinkedList waitList;
	short count;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Semaphore(int initialCount =0);
#ifndef BUG_TOOBIG
// yacc stack overflow
	Semaphore(const Semaphore&);
#endif
	~Semaphore();
	virtual Object* copy() const;		// deepCopy()
	virtual void deepenShallowCopy();
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned hash() const;
	virtual bool includes(const Process&) const;
	virtual bool isEqual(const Object& ob) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual Process* remove(Process&);
	virtual Process* removeFirst();
	virtual Process* removeLast();
	virtual void signal(unsigned n=1);  // signal waiting process 
	virtual int value() const;	// read semaphore value 
	virtual void wait();		// wait on semaphore 
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
