#ifndef	OIOFD_H
#define	OIOFD_H

/*$Header: OIOfd.h,v 2.204 89/10/07 23:20:31 keith Stab $*/

/* IOfd.h -- declarations for NIHCL file Object I/O classes

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892
	May, 1989

Modification History:

$Log:	OIOfd.h,v $
 * Revision 2.204  89/10/07  23:20:31  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:23:10  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/07  14:03:12  keith
 * Clean up cast-away const where possible
 * 
 * Revision 2.202.1.1  89/07/01  21:55:04  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:55:01  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/21  10:54:59  keith
 * Remove code conditional on BUG21.
 * 
 * Revision 2.201.1.2  89/06/01  23:16:36  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:42:56  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:18:58  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200  89/05/12  10:49:39  keith
 * Initial revision for R2.0.
 * 
*/
#include "Object.h"
#include <string.h>
#include <osfcn.h>

class OIOifd : public NIHCL {
	int fd;			// file descriptor
protected:
	virtual Object* readObject(const Class&);
	friend Object* Class::readFrom(OIOifd&) const;
public:
	OIOifd(int filedesc)	{ fd = filedesc; }
	operator int()		{ return fd; }
	OIOifd& operator>>(char& val) {
		get((char*)&val,sizeof(val));
		return *this;
	}
	OIOifd& operator>>(unsigned char& val) {
		get((char*)&val,sizeof(val));
		return *this;
	}
	OIOifd& operator>>(short& val) {
		get((char*)&val,sizeof(val));
		return *this;
	}
	OIOifd& operator>>(unsigned short& val) {
		get((char*)&val,sizeof(val));
		return *this;
	}
	OIOifd& operator>>(int& val) {
		get((char*)&val,sizeof(val));
		return *this;
	}
	OIOifd& operator>>(unsigned int& val) {
		get((char*)&val,sizeof(val));
		return *this;
	}
	OIOifd& operator>>(long& val) {
		get((char*)&val,sizeof(val));
		return *this;
	}
	OIOifd& operator>>(unsigned long& val) {
		get((char*)&val,sizeof(val));
		return *this;
	}
	OIOifd& operator>>(float& val) {
		get((char*)&val,sizeof(val));
		return *this;
	}
	OIOifd& operator>>(double& val) {
		get((char*)&val,sizeof(val));
		return *this;
	}
	int get()			{ char c; get(c); return c; }
	OIOifd&	get(char& c)		{ get(&c,1); return *this; }
	OIOifd&	get(unsigned char& c)	{ get(&c,1); return *this; }
	OIOifd& get(char*, unsigned size);
	OIOifd& get(unsigned char* val, unsigned size) {
		get((char*)val,size*sizeof(*val));
		return *this;
	}
	OIOifd& get(short* val, unsigned size) {
		get((char*)val,size*sizeof(*val));
		return *this;
	}
	OIOifd& get(unsigned short* val, unsigned size) {
		get((char*)val,size*sizeof(*val));
		return *this;
	}
	OIOifd& get(int* val, unsigned size) {
		get((char*)val,size*sizeof(*val));
		return *this;
	}
	OIOifd& get(unsigned int* val, unsigned size) {
		get((char*)val,size*sizeof(*val));
		return *this;
	}
	OIOifd& get(long* val,unsigned size) {
		get((char*)val,size*sizeof(*val));
		return *this;
	}
	OIOifd& get(unsigned long* val,unsigned size) {
		get((char*)val,size*sizeof(*val));
		return *this;
	}
	OIOifd& get(float* val,unsigned size) {
		get((char*)val,size*sizeof(*val));
		return *this;
	}
	OIOifd& get(double* val,unsigned size) {
		get((char*)val,size*sizeof(*val));
		return *this;
	}
	OIOifd& getCString(char*, unsigned maxlen);
};

class OIOofd : public NIHCL {
	int fd;			// file descriptor
	void writeErr();
protected:
	virtual void storeObject(const Object&);
	friend void Object::storeOn(OIOofd&) const;
public:
	OIOofd(int filedesc)	{ fd = filedesc; }
	operator int()		{ return fd; }
	OIOofd& operator<<(const char* val) {
		*this << (unsigned)strlen(val);
		put(val,strlen(val));
		return *this;
	}
	OIOofd& operator<<(char val) {
		put((char*)&val,sizeof(val));
		return *this;
	}
	OIOofd& operator<<(unsigned char val) {
		put((char*)&val,sizeof(val));
		return *this;
	}
	OIOofd& operator<<(short val) {
		put((char*)&val,sizeof(val));
		return *this;
	}
	OIOofd& operator<<(unsigned short val) {
		put((char*)&val,sizeof(val));
		return *this;
	}
	OIOofd& operator<<(int val) {
		put((char*)&val,sizeof(val));
		return *this;
	}
	OIOofd& operator<<(unsigned int val) {
		put((char*)&val,sizeof(val));
		return *this;
	}
	OIOofd& operator<<(long val) {
		put((char*)&val,sizeof(val));
		return *this;
	}
	OIOofd& operator<<(unsigned long val) {
		put((char*)&val,sizeof(val));
		return *this;
	}
	OIOofd& operator<<(float val) {
		put((char*)&val,sizeof(float));
		return *this;
	}
	OIOofd& operator<<(double val) {
		put((char*)&val,sizeof(double));
		return *this;
	}
	OIOofd& put(const char* val,unsigned size) {
		write((const char*)val,size*sizeof(*val));
		return *this;
	}
	OIOofd& put(const unsigned char* val,unsigned size) {
		return put((const char*)val, size);
	}
	OIOofd& put(const short* val,unsigned size) {
		write((const char*)val,size*sizeof(*val));
		return *this;
	}
	OIOofd& put(const unsigned short* val,unsigned size) {
		write((const char*)val,size*sizeof(*val));
		return *this;
	}
	OIOofd& put(const int* val,unsigned size) {
		write((const char*)val,size*sizeof(*val));
		return *this;
	}
	OIOofd& put(const unsigned int* val,unsigned size) {
		write((const char*)val,size*sizeof(*val));
		return *this;
	}
	OIOofd& put(const long* val,unsigned size) {
		write((const char*)val,size*sizeof(*val));
		return *this;
	}
	OIOofd& put(const unsigned long* val,unsigned size) {
		write((const char*)val,size*sizeof(*val));
		return *this;
	}
	OIOofd& put(const float* val,unsigned size) {
		write((const char*)val,size*sizeof(*val));
		return *this;
	}
	OIOofd& put(const double* val,unsigned size) {
		write((const char*)val,size*sizeof(*val));
		return *this;
	}
	OIOofd& putCString(const char*);
	OIOofd& write(const char* buf,unsigned nbyte) {
		if (::write(fd,buf,nbyte) < 0) writeErr();
		return *this;
	}
public:				// type definitions
	enum oioRecordTy {		// binary object I/O record type codes
		storeOnClassRef,	// class reference and object stored
		storeOnClass,		// class and object stored
		storeOnObjectRef	// object reference stored
	};

};

#endif /* OIOFD_H */
