#ifndef OIOTBL_H
#define OIOTBL_H

/*$Header: OIOTbl.h,v 2.204 89/10/07 23:20:27 keith Stab $*/

/* OIOTbl.h -- Specification of tables used by storeOn()/readFrom()

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892
	July, 1988

Modification History:

$Log:	OIOTbl.h,v $
 * Revision 2.204  89/10/07  23:20:27  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:23:05  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:54:59  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:58  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/22  10:15:23  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.1  89/06/01  23:16:33  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201  89/05/12  11:18:48  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200  89/05/12  10:48:51  keith
 * Initial revision for R2.0.
 * 
 * Revision 2.200.1.1  89/04/24  17:20:22  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:32:35  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:11:08  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.1  89/02/08  13:22:57  ted
 * Initial version after renaming from oops
 * 
 * Revision 1.1  88/07/14  18:11:57  keith
 * Initial revision
 * 

*/

#include "IdentDict.h"
#include "OrderedCltn.h"

class StoreOnTbl : public NIHCL {
	IdentDict d;			// object address => object number
	int objNum;			// last object number used
	OrderedCltn c;			// table of classes stored, indexed by class number
	unsigned short classNum;	// last class number used
public:
	StoreOnTbl(unsigned size =256);
	~StoreOnTbl();
	bool add(const Object&, int& num);
	bool addClass(const Class*, unsigned short& num);
	void addMember(const Object&);
};

class ReadFromTbl : public NIHCL {
	OrderedCltn obs;	// table of objects for readFrom()
	OrderedCltn cls;	// table of classes for readFrom()
public:
	ReadFromTbl(unsigned size =1024);
	int add(Object&);
	int add(const Class*);
	Object* objectAt(int);
	const Class* classAt(int);
};

#endif
