#ifndef	LOOKUPKEY_H
#define	LOOKUPKEY_H

/*$Header: LookupKey.h,v 2.204 89/10/07 23:20:17 keith Stab $*/

/* LookupKey.h -- declarations for Dictionary LookupKey

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	LookupKey.h,v $
 * Revision 2.204  89/10/07  23:20:17  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:49  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:54:52  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:49  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:15:07  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  23:29:32  keith
 * Remove copy constructor.
 * 
 * Revision 2.201.1.2  89/06/01  23:16:24  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:42:27  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:18:16  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:59:35  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:08:59  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:16:25  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:29:27  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:07:16  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"

class LookupKey: public VIRTUAL Object {
	DECLARE_MEMBERS(LookupKey);
	Object* akey;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	LookupKey(Object& newKey =*nil);
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual Object* key() const;
	virtual Object* key(Object& newkey);
	virtual void printOn(ostream& strm =cout) const;
	virtual	Object*	value()	const;		    // derivedClassResponsibility()
	virtual	Object*	value(Object& newvalue);    // derivedClassResponsibility()
};

#endif
