/* LinkOb.c -- implementation of singly-linked list Object pointer element

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	October, 1985

Function:

Objects of class LinkOb are used to link Objects into a LinkedList.

$Log:	LinkOb.c,v $
 * Revision 2.204  89/10/07  23:20:08  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:37  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/08  19:11:55  keith
 * Add initialization of virtual base Object to readFrom() constructors
 * 
 * Revision 2.202.1.1  89/07/01  21:54:43  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:38  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:14:46  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/20  23:08:03  keith
 * Add explicit base names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:52:59  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:18:01  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:59:20  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:16:03  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:29:15  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:06:53  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "LinkOb.h"
#include "nihclIO.h"

#define	THIS	LinkOb
#define	BASE	Link
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(LinkOb,1,"$Header: LinkOb.c,v 2.204 89/10/07 23:20:08 keith Stab $",NULL,NULL);

LinkOb::LinkOb(Object& newval)
{
	val = &newval;
}

unsigned LinkOb::capacity() const		{ return val->capacity(); }

int LinkOb::compare(const Object& ob) const	{ return ob.compare(*val); }

void LinkOb::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	val = val->deepCopy();
}

unsigned LinkOb::hash() const			{ return val->hash(); }

bool LinkOb::isEqual(const Object& ob) const	{ return ob.isEqual(*val); }

void LinkOb::dumpOn(ostream& strm) const
{
	val->dumpOn(strm);
}

void LinkOb::printOn(ostream& strm) const
{
	val->printOn(strm);
}

unsigned LinkOb::size() const			{ return val->size(); }

Object* LinkOb::value() const	{ return val; }

Object* LinkOb::value(Object& newval)
{
	Object* temp = val;
	val = &newval;
	return temp;
}

LinkOb::LinkOb(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
	val = Object::readFrom(strm);
}

void LinkOb::storer(OIOout& strm) const
{
	BASE::storer(strm);
	val->storeOn(strm);
}

LinkOb::LinkOb(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
	val = Object::readFrom(fd);
}

void LinkOb::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	val->storeOn(fd);
}
