#ifndef KEYSORTCLTNH
#define KEYSORTCLTNH

/* KeySortCltn.h -- header file for class KeySortCltn

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	S. M. Orlow
	Systex, Inc.
	Beltsville, MD 20705

Contractor:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

Modification History:

$Log:	KeySortCltn.h,v $
 * Revision 2.204  89/10/07  23:20:00  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/22  17:27:54  keith
 * Pre-release
 * 
 * Revision 2.202.1.3  89/08/22  17:27:15  keith
 * Change to operate on LookupKey instead of Assoc.
 * 
 * Revision 2.202.1.2  89/07/03  16:23:15  keith
 * Define storer() functions as workaround for BUG_38
 * in AT&T C++ Translator 2.00.
 * 
 * Revision 2.202.1.1  89/07/01  21:54:37  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:31  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  20:49:35  keith
 * Comment BUG_TOOBIG code.
 * 
 * Revision 2.201.1.3  89/06/22  10:14:35  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:16:11  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:42:14  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:17:55  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:59:11  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:15:44  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:29:08  keith
 * Base revision for R2.0 Beta 6.
 * 
*/

#include "SortedCltn.h"
#include "LookupKey.h"

class Assoc;

class KeySortCltn: public SortedCltn {
	DECLARE_MEMBERS(KeySortCltn);
#ifndef BUG_38
// internal <<AT&T C++ Translator 2.00 06/30/89>> error: bus error (or something nasty like that)
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd& fd)	const	{ SortedCltn::storer(fd); };
	virtual	void storer(OIOout& strm) const	{ SortedCltn::storer(strm); };
#endif
public:
	KeySortCltn(int size =DEFAULT_CAPACITY);
#ifndef BUG_TOOBIG
// yacc stack overflow
	KeySortCltn(const KeySortCltn&);
#endif

	LookupKey* assocAt(int i);
	Object* keyAt(int i);
	Object* valueAt(int i);
	Object* atKey(Object& key);

	Assoc* addAssoc(Object& key,Object& val);
	Collection& addValuesTo(Collection&) const;
	Collection& addKeysTo(Collection&) const;
	Collection& addContentsBeforeTo(Object&,Collection&);

	virtual void deepenShallowCopy();
	virtual int findIndexOf(Object& key) const;
	virtual Range findRangeOfKey(Object& key) const;
	virtual bool includesKey(Object& key) const;
	virtual int occurrencesOfKey(const Object& key) const;
	virtual Object* removeKey(Object& key);
};

#endif
