#ifndef	IDENTSET_H
#define	IDENTSET_H

/*$Header: IdentSet.h,v 2.204 89/10/07 23:19:49 keith Stab $*/

/* IdentSet.h -- declarations for Identity Set

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	IdentSet.h,v $
 * Revision 2.204  89/10/07  23:19:49  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:20  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/03  16:23:12  keith
 * Define storer() functions as workaround for BUG_38
 * in AT&T C++ Translator 2.00.
 * 
 * Revision 2.202.1.1  89/07/01  21:54:22  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:18  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:14:11  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:16:00  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:42:02  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:17:22  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:58:54  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/04/25  10:09:16  keith
 * Remove unused reference to class OrderedCltn.
 * 
 * Revision 2.200.1.1  89/04/24  17:15:20  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:54  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:05:13  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Set.h"

class IdentSet: public Set {
	DECLARE_MEMBERS(IdentSet);
	virtual int findIndexOf(const Object&) const;
#ifndef BUG_38
// internal <<AT&T C++ Translator 2.00 06/30/89>> error: bus error (or something nasty like that)
protected:		// storer() functions for object I/O
	virtual	void storer(OIOofd& fd)	const	{ Set::storer(fd); };
	virtual	void storer(OIOout& strm) const	{ Set::storer(strm); };
#endif
public:
	IdentSet(unsigned size =DEFAULT_CAPACITY);
};

#endif
