/* HeapProc.c -- Implementation of Process with stack on free storage heap

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	January, 1988

Function:
	
Modification History:

$Log:	HeapProc.c,v $
 * Revision 2.204  89/10/07  23:19:40  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/12  23:40:00  keith
 * Remove shouldNotImplement() storer() functions.
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/04  19:40:36  keith
 * Make storer() shouldNotImplement().
 * 
 * Revision 2.202.1.1  89/07/01  21:54:12  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:08  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:13:49  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/20  22:56:47  keith
 * Add explicit base names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/05/19  15:41:49  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:33:33  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.1  89/04/24  17:14:49  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:42  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:54  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.12  89/02/08  13:28:40  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.11  89/01/17  11:41:11  keith
 * Initial version.
 * 

*/

#include "HeapProc.h"
#include "Scheduler.h"
#include "nihclIO.h"

#define	THIS	HeapProc
#define	BASE	Process
#define	BASE_CLASSES BASE::desc()
#define	MEMBER_CLASSES
#define	VIRTUAL_BASE_CLASSES

extern const int NIHCL_BADTRACETBL,NIHCL_STACKOV;

DEFINE_ABSTRACT_CLASS(HeapProc,1,"$Header: HeapProc.c,v 2.204 89/10/07 23:19:40 keith Stab $",NULL,NULL);

HeapProc::HeapProc(const char* name, stackTy* bottom, int priority, unsigned long size)
	: BASE(name, bottom, priority)
{
	stack_size = size; 
}

HeapProc::HeapProc(OIOifd& fd) : BASE(fd) {}

HeapProc::HeapProc(OIOin& strm) : BASE(strm) {}

HeapProc::~HeapProc()
{
	delete stack_bottom;
}

void HeapProc::setupStack()
{
	stackTy* top = topOfStack();
	stackTy* bottom = stack_bottom;
	stack_bottom = new stackTy[stack_size];

#if STACK_GROWS_DOWN
	stack_bottom[0] = (stackTy)UNINITIALIZED;
	unsigned long size = bottom-top;
	copyStack(top+1, stack_bottom+stack_size-size, size);
	long delta = (stack_bottom+stack_size-1 - bottom) * sizeof(stackTy);
#else
	stack_bottom[stack_size-1] = (stackTy)UNINITIALIZED;
	unsigned long size = top-bottom;
	copyStack(bottom, stack_bottom, size);
	long delta = (stack_bottom - bottom) * sizeof(stackTy);
#endif

#ifdef mc68000
	FP() += delta;	// adjust frame pointer
	SP() += delta;	// adjust stack pointer
#endif

#ifdef ibm032

#ifdef UCB43BSD
/* jmpbuf layout:

	jmpbuf[0]	r1	stack pointer
	jmpbuf[1]	r6
	jmpbuf[2]	r7
	jmpbuf[3]	r8
	jmpbuf[4]	r9
	jmpbuf[5]	r10
	jmpbuf[6]	r11
	jmpbuf[7]	r12
	jmpbuf[8]	r13
	jmpbuf[9]	r14
	jmpbuf[10]	r15	return address
	jmpbuf[11]		saved sigmask
	jmpbuf[12] - jmpbuf[15] unused
*/

struct TT_D_COM	{		// structure of AOS 4.3 trace table
	unsigned magic1:8,	// = 0xDF
		code:8,		// = 7
		magic2:8,	// = 0xDF
		first_gpr:4,	// first general register saved
		optw:1,	optx:1,	opty:1, :1;   // option flags
	char	npars:4,	// number of parameters
		frame_reg:4;	// frame pointer register number
	char	fpr_save:8;	// saved fp register mask (if opty==1)
	char	lcl_off_size:2,	// size of lcl_offset
		lcl_offset1:6,	// # words to top of stack frame from frame_reg
		lcl_offsetn[3];	// 6, 14, 22, or 30 bits
};

// Find trace table
	register short* p = (short*)PC();
	while (((*p++ & 0xff00) != 0xdf00) || ((*p & 0xff00) != 0xdf00));
	TT_D_COM* ttp = (TT_D_COM*)--p;
	if (ttp->code != 7) {
		setNIHCLerror(NIHCL_BADTRACETBL,FATAL,ttp,className(),this);
		return;
	}
// Adjust frame pointer register
	if (ttp->frame_reg >= 6) env[ttp->frame_reg-6+1] += delta;
// Adjust stack pointer register
	SP() += delta;
#endif

#ifdef SYSVR2
	SP() += delta;
#endif

#endif

}

unsigned HeapProc::size() const   { return stack_size; }

void HeapProc::switchContext(Process* new_process)
{
// check for stack overflow
#if STACK_GROWS_DOWN
	if (topOfStack() < stack_bottom || stack_bottom[0] != (stackTy)UNINITIALIZED)
		setError(NIHCL_STACKOV,DEFAULT,name());
#else
	if (topOfStack() >= stack_bottom+stack_size || stack_bottom[stack_size-1] != (stackTy)UNINITIALIZED)
		setError(NIHCL_STACKOV,DEFAULT,name());
#endif
	save();
	new_process->switchFrom(this);
}

void HeapProc::switchFrom(HeapProc*)
// switch from active HeapProc to next HeapProc
{
	LONGJMP(env, Scheduler::resume_new_process);
}

void HeapProc::switchFrom(StackProc*)
// switch from active StackProc to next HeapProc
{
	LONGJMP(env, Scheduler::resume_new_process);
}
