/* Class.c -- implementation of class descriptor objects

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!ncifcrf.gov!nih-csl!keith
	Internet: keith%nih-csl@ncifcrf.gov
	September, 1985

Function:
	
Functions pertaining to class Class.  Most of these are defined inline
in object.h.

Modification History:

$Log:	Class.c,v $
 * Revision 2.204  89/10/07  23:18:57  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:23  keith
 * Pre-release
 * 
 * Revision 2.202.1.7  89/07/29  17:07:24  keith
 * Change addSignature() to work if unsigned long > 32 bits.
 * 
 * Revision 2.202.1.6  89/07/08  19:08:00  keith
 * Replace use of Object::operator new() to add object to readFromTbl
 * by Class::addObjectFlag and Object::Object(OIOin&) Object::Object(OIOifd&).
 * 
 * Revision 2.202.1.5  89/07/07  14:02:25  keith
 * Clean up cast-away const where possible
 * 
 * Revision 2.202.1.4  89/07/03  23:08:47  keith
 * Change assocAt() to return 0 instead of nil when assocation
 * not found.
 * 
 * Revision 2.202.1.3  89/07/03  17:45:12  keith
 * Define static member variables.
 * 
 * Revision 2.202.1.2  89/07/03  15:56:06  keith
 * Implement Class::_storeVBase().
 * 
 * Revision 2.202.1.1  89/07/01  21:53:23  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:25  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.5  89/06/21  23:42:03  keith
 * Use _DEFINE_CASTDOWN.
 * 
 * Revision 2.201.1.4  89/06/20  22:17:43  keith
 * Add Object::desc() to VIRTUAL_BASE_CLASSES.
 * 
 * Revision 2.201.1.3  89/06/14  01:02:35  keith
 * Make most member variables of class Class const.
 * 
 * Revision 2.201.1.2  89/06/14  00:34:23  keith
 * Initialize const class members in constructor member
 * initializer list.
 * 
 * Revision 2.201.1.1  89/06/13  22:56:57  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:16:25  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:56:47  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:07:18  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:13:26  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:58  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:03:42  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include <stdarg.h>
#include "Object.h"
#include "String.h"
#include "Dictionary.h"
#include "Assoc.h"
#include "OrderedCltn.h"
#include "IdentSet.h"
#include "nihclIO.h"
#include "OIOTbl.h"

extern const int NIHCL_RDBADSIG,NIHCL_RDBADTYP,NIHCL_RDWRONGCLASS,NIHCL_RDUNKCLASS,NIHCL_UNKCLASS;

#define	THIS	Class
#define	BASE	Object
#define	BASE_CLASSES	BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

/* DEFINE_CLASS */

Object* Class::reader(OIOin&)
{
	setError(NIHCL_RDUNKCLASS,DEFAULT,"Class");
	return 0;
}
Object* Class::reader(OIOifd&)
{
	setError(NIHCL_RDUNKCLASS,DEFAULT,"Class");
	return 0;
}

static Class class_Class("Class",
	ClassList(0,BASE_CLASSES,0), ClassList(0,0), ClassList(0,0),
	1,	// version
	"$Header: Class.c,v 2.204 89/10/07 23:18:57 keith Stab $",
	sizeof(Class), Class::reader, Class::reader, NULL, NULL);

const Class* Class::desc()	{ return &class_Class; }

const Class* Class::isA() const	{ return &class_Class; }

Object* Class::shallowCopy() const	{ return new Class(*this); }

_DEFINE_CASTDOWN(Class)

// head of the list of all Classes, built by the static constructor of class Class 
static Class* allClasses =0;

static Dictionary classDictionary;	// Dictionary of all Classes 
Dictionary& Class::dictionary = classDictionary;

unsigned long Class::readFrom_level = 0;	// reset readFromTbl when 0
unsigned long Class::storeOn_level = 0;		// reset storeOnTbl when 0
unsigned long Class::addObjectFlag = 0;		// add object to readFromTbl when 0
IdentSet* Class::storeVBaseTbl = 0;		// table used by storeOn()
ReadFromTbl* Class::readFromTbl	= 0;		// tables used by readFrom()
StoreOnTbl* Class::storeOnTbl = 0;		// tables used by storeOn()

ClassList::ClassList(const char* arg0, ...)
{
	va_list ap;
	unsigned nargs = 0;
	va_start(ap, arg0);
	do nargs++; while (va_arg(ap, Class*));
	va_end(ap);
	Class** p = clp = new Class*[nargs];
	va_start(ap, arg0);
	while (nargs--) *p++ = va_arg(ap, Class*);
	va_end(ap);
}

Class::Class(const char* name,
	const ClassList& bases, const ClassList& members, const ClassList& vbases,
	unsigned version, const char* ident, unsigned size,
	Object* (*reader)(OIOin&),
	Object* (*binreader)(OIOifd&),
	initorTy initor1, initorTy initor2)
:
	class_name(name),
	class_ident(ident),
	class_bases(bases.clp),
	class_members(members.clp),
	class_vbases(vbases.clp),
	class_version(version),
	inst_size(size),
	inst_reader(reader),
        inst_binreader(binreader),
	class_initor2(initor2)
{
	nextClass = allClasses; allClasses = this;
	class_signature = 0;
	class_number = 0;
//	if (initor1 != 0) initor1(*this);	MASSCOMP cc bug
	initorTy initfun = initor1;
	if (initfun != 0) initfun(*this);
}

Class::Class(const Class& c)
:
	class_name(c.class_name),
	class_bases(c.class_bases),
	class_members(c.class_members),
	class_vbases(c.class_vbases),
	class_version(c.class_version),
	class_ident(c.class_ident),
	class_signature(c.class_signature),
	inst_size(c.inst_size),
	inst_reader(c.inst_reader),
        inst_binreader(c.inst_binreader),
	class_initor2(c.class_initor2),
	class_number(c.class_number)
{
}

Class::Class(OIOifd&)
:
	class_bases(0),
	class_members(0),
	class_vbases(0),
	class_version(0),
	inst_size(0),
	inst_reader(0),
	inst_binreader(0),
	class_initor2(0)
{
}

Class::Class(OIOin&)
:
	class_bases(0),
	class_members(0),
	class_vbases(0),
	class_version(0),
	inst_size(0),
	inst_reader(0),
	inst_binreader(0),
	class_initor2(0)
{
}

int Class::compare(const Object& ob) const	// compare Class names 
{
	assertArgSpecies(ob,class_Class,"compare");
	return strcmp(name(),castdown(ob).name());
}

unsigned Class::hash() const	{ return (const unsigned)this; }

bool Class::isEqual(const Object& ob) const	{ return this == castdown(&ob); }

bool Class::_isKindOf(const Class& clid) const
{
    if (this == &clid) return YES;
    const Class** bp = baseClasses();
    while (*bp) if ((*bp++)->_isKindOf(clid)) return YES;
    return NO;
}

void Class::deepenShallowCopy()	{ shouldNotImplement("deepenShallowCopy"); }

void Class::dumpOn(ostream& strm) const
{
	strm << className() << '[' << name() << '\n';
	strm << "ident: " << ident() << '\n';
	strm << "version: " << version() << '\n';
	strm << "signature: " << signature() << '\n';
	strm << "number: " << number() << '\n';
	strm << "base classes:";
	const Class** p = baseClasses();
	while (*p) strm << ' ' << (*p++)->name();
	strm << '\n';
	strm << "member classes:";
	p = memberClasses();
	while (*p) strm << ' ' << (*p++)->name();
	strm << '\n';
	strm << "virtual base classes:";
	p = virtualBaseClasses();
	while (*p) strm << ' ' << (*p++)->name();
	strm << '\n';
	strm << "]\n";
}

void Class::printOn(ostream& strm) const	{ strm << class_name; }

unsigned Class::size() const	{ return inst_size; }
	
void Class::addSignature(unsigned long s)
{
// Assumes that an unsigned long is at least 32 bits
	class_signature = ((class_signature << 3) + (class_signature >> (32-3) & 7) + s) & 0xFFFFFFFF;
}

void Class::computeSignature()
{
	if (this == Object::desc()) {
		class_signature = class_version;
		return;
	}
	Class** p = (Class**)class_bases;
	while (*p) addSignature((*p++)->signature());
	if (class_signature == 0) class_signature++;
	p = (Class**)class_members;
	while (*p) addSignature((*p++)->signature());
	if (class_version != 0) addSignature(class_version);
	if (class_signature == 0) class_signature++;
}

const Class* Class::lookup(const char* name)
// Find the class descriptor for class "name"
{
	LookupKey* asc = dictionary.assocAt(String(name));
	if (asc == 0) return 0;
	return castdown(asc->value());
}

Object* Class::readFrom(OIOin& strm) const
{
	if (readFrom_level++ == 0) readFromTbl = new ReadFromTbl;
	Object* target = strm.readObject(*this);
	if (--readFrom_level == 0) {
	    delete readFromTbl;
	    readFromTbl = 0;
	}
	return target;
}

Object* Class::readObject(OIOin& strm) const
// Called by OIOin::readObject()
{
#ifdef DEBUG_OBJIO
	cerr << "readFrom: read instance of class " << name();
#endif
	addObjectFlag = 0;	// causes Object::Object(OIOin&) to do Class::readFromTbl->add()
	return (*inst_reader)(strm);
}

Object::Object(OIOin&)
{
	if (Class::addObjectFlag++ == 0) {
		int objectNum = Class::readFromTbl->add(*this);	// add object to readFromTbl
#ifdef DEBUG_OBJIO
		cerr << ", object #" << objectNum << "\n";
#endif
	}
}

Object* Class::readFrom(OIOifd& fd) const
{
	if (readFrom_level++ == 0) readFromTbl = new ReadFromTbl;
	Object* target = fd.readObject(*this);
	if (--readFrom_level == 0) {
	    delete readFromTbl;
	    readFromTbl = 0;
	}
	return target;
}

Object* Class::readObject(OIOifd& fd) const
// Called by OIOifd::readObject()
{
#ifdef DEBUG_OBJIO
	cerr << "readFrom: read instance of class " << name();
#endif
	addObjectFlag = 0;    // causes Object::Object(OIOifd&) to do Class::readFromTbl->add();
	return (*inst_binreader)(fd);
}

Object::Object(OIOifd&)
{
	if (Class::addObjectFlag++ == 0) {
		int objectNum = Class::readFromTbl->add(*this);	// add object to readFromTbl
#ifdef DEBUG_OBJIO
		cerr << ", object #" << objectNum << "\n";
#endif
	}
}

void Class::initialize()	// class initialization
{
	register Class*	clp = allClasses;   // add all classes to class dictionary

#ifdef DEBUG
while (clp != NULL) { clp->dumpOn(); clp = clp->nextClass; }
clp = allClasses;
#endif

	while (clp != NULL) {
		clp->signature();	// compute class signatures
		dictionary.add(*new Assoc(*new String(clp->name()), *clp));
		clp = clp->nextClass;
	}
	clp = allClasses;	// call the initor2 functions
	while (clp != NULL) {
		if (clp->class_initor2 != 0) (*clp->class_initor2)(*clp);
		clp = clp->nextClass;
	}
}

bool Class::_storeVBase(void* p)
{
	if (storeVBaseTbl == 0) {
		storeVBaseTbl = new IdentSet(256);
		storeVBaseTbl->add(*(Object*)p);
		return YES;
	}
	if (storeVBaseTbl->includes(*(Object*)p)) return NO;
	storeVBaseTbl->add(*(Object*)p);
	return YES;
}

void Class::storer(OIOout&) const { shouldNotImplement("storer"); }

void Class::storer(OIOofd&) const { shouldNotImplement("storer"); }
