/* AssocInt.c -- implementation of key-Integer association

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985

Function:

Objects of class AssocInt associate a key object with an Integer value
object.  They are used to implement Bags, which use a Dictionary to
associate objects with their occurrence counts.

$Log:	AssocInt.c,v $
 * Revision 2.204  89/10/07  23:18:42  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:03  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/08  19:10:54  keith
 * Add initialization of virtual base Object to readFrom() constructors
 * 
 * Revision 2.202.1.1  89/07/01  21:53:05  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:04  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/20  21:46:29  keith
 * Add explicit base names to constructor initializer
 * lists.
 * Initialize member avalue in initializer list.
 * 
 * Revision 2.201.1.2  89/06/20  21:44:33  keith
 *  Add explicit base names to constructor initializer
 * lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:56:25  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:16:05  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:56:06  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:12:22  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:37  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:03:06  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "AssocInt.h"
#include "nihclIO.h"

#define	THIS	AssocInt
#define	BASE	LookupKey
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES Integer::desc()
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(AssocInt,1,"$Header: AssocInt.c,v 2.204 89/10/07 23:18:42 keith Stab $",NULL,NULL);

AssocInt::AssocInt(Object& newKey, int newValue)
	: BASE(newKey), avalue(newValue)
{
}

Object* AssocInt::value() const { return &avalue; }

Object* AssocInt::value(Object& newValue)
{
	assertArgClass(newValue,*Integer::desc(),"value");
	avalue = Integer::castdown(newValue);
	return &avalue;
}

void AssocInt::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	avalue.deepenShallowCopy();
}

static int intval;

AssocInt::AssocInt(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm),
	avalue((strm >> intval, intval))
{
}

void AssocInt::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << avalue.value();
}

AssocInt::AssocInt(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd),
	avalue((fd >> intval, intval))
{
}

void AssocInt::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << avalue.value();
}
