#ifndef	ARRAYOB_H
#define	ARRAYOB_H

/*$Header: ArrayOb.h,v 2.204 89/10/07 23:18:29 keith Stab $*/

/* ArrayOb.h -- declarations for array of object pointers

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	ArrayOb.h,v $
 * Revision 2.204  89/10/07  23:18:29  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:20:49  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:52:50  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/24  13:23:27  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/24  13:21:12  keith
 * Move include of malloc.h from .h to .c file.
 * 
 * Revision 2.201.1.3  89/06/22  10:00:02  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:12:48  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:38:53  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:15:35  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.4  89/05/12  10:55:26  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.3  89/05/05  09:56:26  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.2  89/05/03  23:06:31  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  16:50:57  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:20  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:02:39  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Collection.h"

class ArrayOb: public Collection {
	DECLARE_MEMBERS(ArrayOb);
	Object** v;
	unsigned sz;
	void allocSizeErr() const;
	void indexRangeErr() const;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	ArrayOb(unsigned size =DEFAULT_CAPACITY);
	ArrayOb(const ArrayOb&);
	~ArrayOb();
	Object*& elem(int i)			{ return v[i]; }
	const Object *const& elem(int i) const	{ return v[i]; }
	bool operator!=(const ArrayOb& a) const	{ return !(*this==a); }
	void operator=(const ArrayOb&);
	bool operator==(const ArrayOb&) const;
	Object*& operator[](int	i)	{
		if ((unsigned)i >= sz) indexRangeErr();
		return v[i];
	}
	const Object *const& operator[](int i) const	{
		if ((unsigned)i >= sz) indexRangeErr();
		return v[i];
	}
	virtual Collection& addContentsTo(Collection&) const;
	virtual Object*& at(int i);
	virtual const Object *const& at(int i) const;
	virtual unsigned capacity() const;
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();
	virtual Object* doNext(Iterator&) const;
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void reSize(unsigned);
	virtual void removeAll();
	virtual unsigned size() const;
	virtual void sort();
	virtual const Class* species() const;
private:			    // shouldNotImplement();
	virtual	Object* add(Object&);
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Object&);
};

#endif
