/* ArrayOb.c -- member functions of class ArrayOb

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985

Function:
	
Member function definitions for class ArrayOb (Array of Object*).
Objects of class ArrayOb are used in the implementations of several
other Collection classes such as: Bag, Dictionary, Set, and
OrderedCltn.  Note that the ArrayOb constructor initializes the array
with pointers to the nil object.

$Log:	ArrayOb.c,v $
 * Revision 2.204  89/10/07  23:18:26  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:20:46  keith
 * Pre-release
 * 
 * Revision 2.202.1.3  89/07/08  19:10:45  keith
 * Add initialization of virtual base Object to readFrom() constructors
 * 
 * Revision 2.202.1.2  89/07/07  14:02:11  keith
 * Clean up cast-away const where possible
 * 
 * Revision 2.202.1.1  89/07/01  21:52:46  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/24  13:23:25  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/24  13:20:33  keith
 * Move include of malloc.h from .h to .c file.
 * 
 * Revision 2.201.1.2  89/06/20  21:33:48  keith
 * Add explicit base names to constructor initializer
 * lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:55:51  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:15:03  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.4  89/05/12  10:54:22  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.3  89/05/05  09:54:55  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.2  89/05/03  23:06:02  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  16:49:25  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:26:58  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:01:28  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include <libc.h>
#include <malloc.h>
#include "ArrayOb.h"
#include "nihclIO.h"

#define	THIS	ArrayOb
#define	BASE	Collection
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(ArrayOb,1,"$Header: ArrayOb.c,v 2.204 89/10/07 23:18:26 keith Stab $",NULL,NULL);

extern const int NIHCL_ALLOCSIZE,NIHCL_INDEXRANGE;

/*
Note: we use malloc()/free() here instead of new/delete because
we use realloc() to implement reSize().
*/

#define NEW(type,size)	((type*)malloc(sizeof(type)*(size)))

inline void DELETE(Object** ptr) { free((char*)ptr); }

inline Object** REALLOC(Object** ptr, unsigned size)
{
	return (Object**)realloc((char*)ptr,sizeof(Object*)*size);
}

ArrayOb::ArrayOb(unsigned size)
{
	sz = size;
	if (sz==0) allocSizeErr();
	v = NEW(Object*,sz);
	register i = sz;
	register Object** vp = v;
	while (i--) *vp++ = nil;
}
	
ArrayOb::ArrayOb(const ArrayOb& a)
{
	register i = a.sz;
	sz = i;
	v = NEW(Object*,i);
	register Object** vp = v;
	register Object** av = a.v;
	while (i--) *vp++ = *av++;
}

ArrayOb::~ArrayOb()	{ DELETE(v); }

void ArrayOb::operator=(const ArrayOb& a)
{
	if (v != a.v) {
		DELETE(v);
		v = NEW(Object*,sz=a.sz);
		register i = a.sz;
		register Object** vp = v;
		register Object** av = a.v;
		while (i--) *vp++ = *av++;
	}
}

bool ArrayOb::operator==(const ArrayOb& a) const
{
	if (sz != a.sz) return NO;
	register unsigned i = sz;
	register Object** vp = v;
	register Object** av = a.v;
	while (i--) { if (!((*vp++)->isEqual(**av++))) return NO; }
	return YES;
}

Object*& ArrayOb::at(int i)			{ return (*this)[i]; }

const Object *const& ArrayOb::at(int i) const	{ return (*this)[i]; }

unsigned ArrayOb::capacity() const	{ return sz; }
	
bool ArrayOb::isEqual(const Object& a) const
{
	return a.isSpecies(classDesc) && *this==castdown(a);
}

const Class* ArrayOb::species() const { return &classDesc; }

void ArrayOb::reSize(unsigned newsize)
{
	if (newsize == 0) allocSizeErr();
	v = REALLOC(v,newsize);
	if (newsize > sz) {	// initialize new space to nil
		Object** vp = &v[sz];
		while (newsize > sz) {
			*vp++ = nil;
			sz++;
		}
	}
	else sz = newsize;
}

void ArrayOb::removeAll()
{
	register Object** vp = v;
	register unsigned i = sz;
	while (i--) *vp++ = nil;
}

Collection& ArrayOb::addContentsTo(Collection& cltn) const
{
	register Object** vp = v;
	register unsigned i = sz;
	while (i--) cltn.add(**vp++);
	return cltn;
}

Object* ArrayOb::doNext(Iterator& pos) const
{
	if (pos.index < size()) return v[pos.index++];
	return 0;
}

void ArrayOb::deepenShallowCopy()
{
	BASE::deepenShallowCopy();
	register i = sz;
	register Object** vp = v;
	while (i--) {
		*vp = (*vp)->deepCopy();
		vp++;
	}
}

unsigned ArrayOb::hash() const
{
	register unsigned h = sz;
	register unsigned i = sz;
	register Object** vp = v;
	while (i--) h^=(*vp++)->hash();
	return h;
}

ArrayOb::ArrayOb(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
	strm >> sz;
	v = NEW(Object*,sz);
	for (register unsigned i=0; i<sz; i++) v[i] = Object::readFrom(strm);
}

void ArrayOb::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << sz;
	for (register unsigned i=0; i<sz; i++) v[i]->storeOn(strm);
}

unsigned ArrayOb::size() const	{ return sz; }

static int compare_ob(const void* a, const void* b)
{
	return (*(const Object**)a)->compare(**(const Object**)b);
}

void ArrayOb::sort()
{
	qsort(v,sz,sizeof(Object*),compare_ob);
}

void ArrayOb::allocSizeErr() const
{
	setError(NIHCL_ALLOCSIZE,DEFAULT,this,className());
}

void ArrayOb::indexRangeErr() const
{
	setError(NIHCL_INDEXRANGE,DEFAULT,this,className());
}

ArrayOb::ArrayOb(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
	fd >> sz;
	v = NEW(Object*,sz);
	for (register unsigned i=0; i<sz; i++ )
	   v[i] = Object::readFrom(fd);
}

void ArrayOb::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << sz;
	for (register unsigned i=0; i<sz; i++) 
		v[i]->storeOn(fd);
}

int ArrayOb::compare(const Object& arg) const
// Compare two arrays of objects.  If *this > arg return >0,
// *this == arg return 0, and if *this < arg return <0.
{
	assertArgSpecies(arg,classDesc,"compare");
	const ArrayOb& a = castdown(arg);
	for (int i=0; i<sz; i++) {
// previous elements compared equal; longer ArrayOb is therefore larger
		if (i == a.sz) return 1;
// compare() != 0 at any element determines ordering
		int val;
		if ((val = v[i]->compare(*a.v[i])) != 0) return val;
	}
// all elements in this ArrayOb compare() equal to arg ArrayOb
	if (sz == a.sz) return 0;
	return -1;
}

Object* ArrayOb::add(Object& ob)
{
	shouldNotImplement("add");
	return &ob;
}

unsigned ArrayOb::occurrencesOf(const Object&) const
{
	shouldNotImplement("occurrencesOf");
	return 0;
}

Object* ArrayOb::remove(const Object&)
{
	shouldNotImplement("remove");
	return 0;
}
