// ex7-2.c -- Improved geometry class hierarchy using NIH class library

// $Header: ex7-2.c,v 2.204 89/10/08 14:42:07 keith Stab $

#include <fstream.h>
#include <osfcn.h>
#include "Point.h"
#include "Line.h"
#include "Circle.h"
#include "Picture.h"
#include "OIOnih.h"

main()
{
    Line l(Point(1,2),Point(3,4));
    Circle c(Point(5,6),1);
    Picture subPic;
    subPic.add(l);
    subPic.add(c);

    Picture bigPic;
    bigPic.add(*(Shape*)subPic.shallowCopy());
    bigPic.add(*(Shape*)subPic.deepCopy());
    bigPic.add(l);
    cout << "\n* Original bigPic:\n";
    bigPic.draw();

    subPic.move(Point(10,10));
    cout << "\n* After moving subPic:\n";
    bigPic.draw();

    l.move(Point(10,10));
    c.move(Point(10,10));
    cout << "\n* After moving l and c:\n";
    bigPic.draw();

    ofstream out("picturefile",ios::out,0664);  // UNIX protection mode 0664
    if (out.fail()) {
        cerr << "Failed to open picturefile\n";
        exit(1);
    }
    bigPic.storeOn(OIOnihout(out));
}
