// ex13-7.c -- Calling a virtual function from a base class constructor

// $Header: ex13-7.c,v 2.204 89/10/08 14:40:45 keith Stab $

#include <iostream.h>

class V {
public:
    virtual void vf();
};

void V::vf()    { cout << "V::vf()" << endl; }

class A: public virtual V {
public:
    A()         { /* ... */ }
    virtual void vf();
};

void A::vf()    { cout << "A::vf()" << endl; }

class B: public virtual V {
public:
    B()         { vf(); }   // Calls A::vf(), not V::vf() or C::vf()
};

class C: public A, public B {
public:
    C()         { vf(); }   // Calls C::vf()
    virtual void vf();
};

void C::vf()    { cout << "C::vf()" << endl; }

main()
{
    C c;
}
