/*----------------------------------------------------------------------*\
| XMMACROS.h
|
| This file contains macros that support activation entry points.
\*----------------------------------------------------------------------*/

#define DECLARE_MOTIF_APPLICATION XMShell s; XTInitialize(&s,"main","DEmo1",NULL,NULL,&argc,argv);
#define INIT_MOTIF_APPLICATION  XTInitialize(&s,"main","DEmo1",NULL,NULL,&argc,argv);
#define MAIN &s
#define ACTIVATE_ENTRIES XTRealizeWidget(&s);XTMainLoop();

#define DECLARE_ENTRY(f) void f(Widget,caddr_t,caddr_t );
#define ENTRY(f,t,p,c1,c2)  void f(Widget ww,caddr_t c1,caddr_t c2){t *p;p=(t *)cb_locate_object(ww);
// Macro to define the callback with both call and client data of any type
#define DECLARE_ENTRY_F(f,cl,ca) void f(Widget,cl,ca );
#define ENTRY_F(f,t,p,cl,c1,ca,c2)  void f(Widget ww,cl c1,ca c2){t *p;p=(t *)cb_locate_object(ww);

#define SHORT_ENTRY(f,t,p)  void f(Widget ww,caddr_t __c1,caddr_t __c2){t *p;p=(t *)cb_locate_object(ww);

#define DECLARE_EVENT(f) void f(Widget,caddr_t,XEvent*);
#define EVENT(f,t,p,c,e)  void f(Widget ww,caddr_t c,XEvent* e){t *p;p=(t *)cb_locate_object(ww);

#define DECLARE_ACTION(f) void f(Widget, XEvent*, String*, Cardinal*);
#define ACTION(f,t,p,e,s,c)  void f(Widget ww,XEvent* e,String* s,Cardinal* c){t *p;p=(t *)cb_locate_object(ww);

#define DEFXSTRING(a) XmStringLtoRCreate(a, XmSTRING_DEFAULT_CHARSET)

#define BIND_CALLBACK( CLA, NAME, ARGNAME ) void CLA:: NAME \
(XtCallbackProc func,\
caddr_t client_data) {XtAddCallback(w, ARGNAME, func, client_data);}\

#define GET_BIND(CLA,NAME,ARGNAME,TYP) void CLA:: NAME (TYP acc) \
{if (args_count<args_size) \
    {XtSetArg(args[args_count], ARGNAME,acc); args_count++; \
     if(immediate){XtGetValues(w,args,args_count); args_count=0;}\
}\
 else\
  printf ("***WARNING : BUFFER SIZE EXCEEDED, NOT SETTING ARGUMENT\n");\
}

#define SET_BIND(CLA,NAME,ARGNAME,TYP) void CLA:: NAME (TYP acc) \
{if (args_count<args_size) \
    {XtSetArg(args[args_count], ARGNAME,acc); args_count++; \
     if(immediate){XtSetValues(w,args,args_count); args_count=0;}\
}\
 else\
  printf ("***WARNING : BUFFER SIZE EXCEEDED, NOT SETTING ARGUMENT\n");\
}

#define SET_BIND_O(CLA,NAME,ARGNAME) void CLA:: NAME (XMObject* obj) \
{if (args_count<args_size) \
    {XtSetArg(args[args_count], ARGNAME,obj->get_widget()); args_count++; \
     if(immediate){XtSetValues(w,args,args_count); args_count=0;}\
}\
 else\
  printf ("***WARNING : BUFFER SIZE EXCEEDED, NOT SETTING ARGUMENT\n");\
}

#define GET_BIND_O(CLA,NAME,ARGNAME) void CLA:: NAME (XMObject* obj) \
{Widget ww; XtSetArg(args[args_count], ARGNAME,ww); \
XtGetValues(w,&args[args_count],(int)1); obj = cb_locate_object(ww);}\

#define SET_BIND_S(CLA,NAME,ARGNAME) void CLA:: NAME (XMString* str) \
{if (args_count<args_size) \
    {XtSetArg(args[args_count], ARGNAME,str->get_string()); args_count++; \
     if(immediate){XtSetValues(w,args,args_count); args_count=0;}\
}\
 else\
  printf ("***WARNING : BUFFER SIZE EXCEEDED, NOT SETTING ARGUMENT\n");\
}

//#define GET_BIND_S(CLA,NAME,ARGNAME) void CLA:: NAME (XMString* str) \
//{XtSetArg(args[args_count], ARGNAME,str->get_string()); \
//args_count++; if(immediate){XtGetValues(w,args,args_count);\
//args_count=0;}}\

#define GET_BIND_S(CLA,NAME,ARGNAME) void CLA:: NAME (XMString* str) \
{XMString temp(""); XmString temp_s; \
 if (args_count<args_size) \
    {XtSetArg(args[args_count], ARGNAME,&(temp_s)); args_count++; \
     if(immediate){XtGetValues(w,args,args_count); args_count=0;}\
     if(str!=NULL) delete str; temp.set_string (temp_s); str = &temp;\
}\
 else\
  printf ("***WARNING : BUFFER SIZE EXCEEDED, NOT SETTING ARGUMENT\n");\
}

// Modified by KS/CR to take care of get string
//#define GET_BIND_S(CLA,NAME,ARGNAME) void CLA:: NAME (XMString* str) \
//{XMString temp(); XtSetArg(args[args_count], ARGNAME,&(temp.s_s)); \
//args_count++; if(immediate){XtGetValues(w,args,args_count);\
//args_count=0;}if(str!=NULL) delete str; str = &temp;}\

#define SET_BIND_F(CLA,NAME,ARGNAME) void CLA:: NAME (XMFontList* fnt) \
{if (args_count<args_size) \
    {XtSetArg(args[args_count], ARGNAME,fnt->get_fontlist()); args_count++; \
     if(immediate){XtSetValues(w,args,args_count); args_count=0;}\
}\
 else\
  printf ("***WARNING : BUFFER SIZE EXCEEDED, NOT SETTING ARGUMENT\n");\
}

#define GET_BIND_F(CLA,NAME,ARGNAME) void CLA:: NAME (XMFontList* fnt) \
{if (args_count<args_size) \
    {XtSetArg(args[args_count], ARGNAME,fnt->get_fontlist()); args_count++; \
     if(immediate){XtGetValues(w,args,args_count); args_count=0;}\
}\
 else\
  printf ("***WARNING : BUFFER SIZE EXCEEDED, NOT SETTING ARGUMENT\n");\
}

#define SET_BIND_C(CLA,NAME,ARGNAME,TYP) void CLA:: NAME (XMObject* obj, TYP acc) \
{Arg args[1]; XtSetArg(args[0], ARGNAME,acc); \
 XtSetValues(obj->get_widget(),args,1);}\

#define SET_BIND_C_O(CLA,NAME,ARGNAME) void CLA:: NAME (XMObject* obj, XMObject* acc) \
{Arg args[1]; XtSetArg(args[0], ARGNAME,acc->get_widget()); \
 XtSetValues(obj->get_widget(),args,1);}\

#define GET_BIND_C(CLA,NAME,ARGNAME,TYP) void CLA:: NAME (XMObject* obj, TYP acc) \
{Arg args[1]; XtSetArg(args[0], ARGNAME,acc); \
 XtSetValues(obj->get_widget(),args,1);}\

#define GET_BIND_C_O(CLA,NAME,ARGNAME) void CLA:: NAME (XMObject* obj, XMObject* acc) \
{Arg args[1]; XtSetArg(args[0], ARGNAME,acc->get_widget()); \
 XtSetValues(obj->get_widget(),args,1);}




