//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
//
// Created: BMK 07/14/89 -- Initial design and implementation
// Updated: LGO 09/23/89 -- Conform to COOL coding style
// Updated: AFM 12/31/89 -- OS/2 port
// Updated: DLS 03/22/91 -- New lite version
//
// The Timer class provides timing code  for performance evaluation.  This code
// was originally written by Joe Rahmeh at UT Austin.
//

#include <sys/types.h>

#if defined(DOS)
extern "C" {
#include <sys/timeb.h>
#include <time.h>
}
#else
#include <sys/timeb.h>
#include <sys/time.h>
#include <sys/resource.h>
/* extern int getrusage (int, rusage *);
extern int ftime (timeb *);
*/
#endif


class Timer {
private:
#if defined(DOS) || defined(MSDOS)
  clock_t usage0;
#else
  rusage  usage0;	// rusage structure at last mark
#endif
  timeb   real0;	// elapsed real time at last mark

public:
  Timer () {mark();}	// constructor
  
  void mark ();		// mark timer
  
  long user ();		// user        time (ms) since last Mark
  long system ();	// system      time (ms) since last Mark
  long all ();		// user+system time (ms) since last Mark
  long real ();		// real        time (ms) since last Mark
  
  long user_usec ();	// user        time (us) since last Mark
  long system_usec ();	// system      time (us) since last Mark
  long all_usec ();	// user+system time (us) since last Mark
};

