/*
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
*/

#include "par.h"

#include <errno.h>
#ifdef VMS
#include <unixio.h>
#endif

#ifndef AR_CMD
#ifdef os2
#define AR_CMD "lib /PAGESIZE:64"
#else
#define AR_CMD "ar "
#endif
#endif

char    *ar_cmd = AR_CMD;
char	*ar_replace = AR_REPLACE;
char	*ar_delete = AR_DELETE;
char	*ar_add = AR_ADD;
char    *archive = NULL;
char    ar_options[100];
char	*filelist[ MAXFILES ];
char    *ProgramName;

main(argc, argv)
	int	argc;
	char	**argv;
{

	register char	**fp = filelist;
	register char	**temp;
	register char	*p, *eof;
	char    *fname = NULL;
	char    cmd_line[255];
	char    *bol;
	struct filepointer	*filecontent;
	
	if(argc < 3) {
		fprintf(stderr,"usage: par <archive> [adr] @FILELIST\n");
		exit(1);
	}

#ifdef os2
	strcpy (ar_options, "/nologo ");
#endif
	ProgramName = argv[0];

	for(argc--, argv++; argc; argc--, argv++) {
		if (**argv == '@') {
			/* all file names are contained in a filename
			   following the @-sign (OS/2 only). */
			filecontent = getfile(argv[0]+1);
			p = filecontent->f_p;
			eof = filecontent->f_end;
			while (p < eof) {
				bol = p;
				for(; *p != ' ' && *p != '\n' && p < eof;p++);
				fname = malloc(p-bol+1);
				*p = '\0';
				if(isalpha(*bol) || isdigit(*bol)) {
					strcpy(fname,bol);
					for (temp = filelist; *temp; temp++)
						if(strcmp(fname,*temp) == 0)
							break;
					if (*temp == NULL)
						*fp++ = fname;
				}
				for(p++; isspace(*p) && p < eof;p++);
			}
			freefile(filecontent);
			break;
		}
		else if (**argv != '-') {
			archive = argv[0];
			continue;
		}
		else switch (*(argv[0]+1)) {
			case 'a':
				strcat(ar_options, ar_add);
				strcat(ar_options, " ");
				break;
			case 'd':
				strcat(ar_options, ar_delete);
				strcat(ar_options, " ");
				break;
			case 'r':
				strcat(ar_options, ar_replace);
				strcat(ar_options, " ");
				break;
			default:
				do_log("invalid option: -%c\n", *(argv[0]+1));
				exit(1);
		}
	}


	/*
	 * now peruse through the list of files, passing each to archive
	 */
	for(fp=filelist; *fp; fp++) {
		fprintf(stderr, "%s\n",*fp);
		strcpy (cmd_line, ar_cmd);
		strcat (cmd_line, " ");
		strcat (cmd_line, archive);
		strcat (cmd_line, " ");
		strcat (cmd_line, ar_options);
		strcat (cmd_line, " ");
		strcat (cmd_line, *fp);
		strcat (cmd_line, ";");
		system(cmd_line);
	}
	exit(0);
}

struct filepointer *getfile(file)
	char	*file;
{
	register long	i;
	struct filepointer	*content;
	struct stat	st;
	FILE   *fd;

	content = (struct filepointer *)malloc(sizeof(struct filepointer));
	if ((fd = fopen(file, "r")) == NULL) {
		do_log("cannot open \"%s\" [errno=%d]\n", file, errno);
		content->f_p = content->f_base = content->f_end = malloc(1);
		*content->f_p = '\0';
		return(content);
	}
	stat(file, &st);
	content->f_len = st.st_size+1;
	content->f_base = malloc(content->f_len);
	if (content->f_base == NULL)
	  log_fatal("cannot allocate mem\n");
	for (i = 0; i < st.st_size; ++i)
	  content->f_base[i] = getc (fd);
	fclose(fd);
	content->f_p = content->f_base;
	content->f_end = content->f_base + st.st_size;
	*content->f_end = '\0';
	content->f_line = 0;
	return(content);
}

freefile(fp)
	struct filepointer	*fp;
{
	free(fp->f_base);
	free(fp);
}

/*VARARGS*/
log_fatal(x0,x1,x2,x3,x4,x5,x6,x7,x8,x9)
char* x0;
{
	do_log(x0,x1,x2,x3,x4,x5,x6,x7,x8,x9);
	exit (1);
}

/*VARARGS0*/
do_log(x0,x1,x2,x3,x4,x5,x6,x7,x8,x9)
char* x0;
{
	fprintf(stderr, "%s:  ", ProgramName);
	fprintf(stderr, x0,x1,x2,x3,x4,x5,x6,x7,x8,x9);
}

