//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/Complex.h>			// Include complex header file

#define FREQUENCY 346.87
#define OMEGA (2 * 3.14159265358979323846 * FREQUENCY)

inline Complex in_series (const Complex& c1, const Complex& c2) {
  return (c1+c2);
}

inline Complex in_parallel (const Complex& c1, const Complex& c2) {
  return ((c1.invert() + c2.invert()).invert ());
}

inline Complex resistor (double r) {
  return Complex (r);
}

inline Complex inductor (double i) {
  return (Complex (0.0, i * OMEGA));
}

inline Complex capacitor (double c) {
  return (Complex (0.0, -1.0 / (c * OMEGA)));
}

int main (void) {
  Complex circuit;
  circuit = in_series (resistor (1.0),
		       in_parallel (in_series (resistor (100.0),
					       inductor (0.2)),
				    in_parallel (capacitor (0.000001),
						 resistor (10000000.0))));
  cout << "Circuit impedence is " << circuit << " at frequency " << FREQUENCY << "\n";
  return 0;					// Exit with OK status
}
