//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 08/31/89 -- Initial design and implementation
// Updated: LGO 09/19/89 -- Split into seperate files
// Updated: MJF 03/12/90 -- Added group names to RAISE
//

#include <cool/Base_Vector.h>			// Include the class header
#include <cool/Generic.h>			// Include the class header


// void set_growth_ratio (float) -- Set the growth percentage for the Vector
//                                  object.
// Input:                           Float ratio, type
// Output:                          None

void Vector::set_growth_ratio (float ratio, const char* Type) {
#if ERROR_CHECKING
  if (ratio <= 0.0)				// If non-positive growth
    RAISE (Error, SYM(Vector), SYM(Negative_Ratio),
	   "Vector<%s>::set_growth_ratio(): Negative growth ratio %f",
	   Type, ratio);
#endif
  this->growth_ratio = ratio;			// Adjust ration
}
