//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//

#include <cool/String.h>
#include <cool/Stack.h>
#include <test.h>
 
DECLARE Stack<int>;
IMPLEMENT Stack<int>;
DECLARE Stack<char*>;
IMPLEMENT Stack<char*>;
DECLARE Stack<String>;
IMPLEMENT Stack<String>;


Boolean my_compare_charP (const charP& s1, const charP& s2) {
  return (strcmp (s1, s2) ? FALSE : TRUE);
}

void test_int () {
  Stack<int> s0;
  TEST("Stack<int> s0", 1, 1);
  Stack<int> s1(4);
  TEST("Stack<int> s1", 1, 1);
  Stack<int> s2(4);
  s1.pushn(7, 4);
  TEST("s1.push(7, 4)", (s1[3]==7 && s1[2]==7 && s1[1]==7 && s1[0]==7), TRUE);
  TEST("s1.length()", s1.length(), 4);
  s2.push(7);
  TEST("s2.push(7)", (s2[0]==7), TRUE);
  s2.push(7);
  TEST("s2.push(7)", (s2[0]==7), TRUE);
  s2.pushn(7, 2);
  TEST("s2.pushn(7, 2)", 1, 1);
  TEST("s1.operator==(s2)", s1.operator==(s2), TRUE);
  TEST("s2.operator!=(s1)", s2.operator!=(s1), FALSE);
  s2.pop();
  TEST("s2.pop()", (s2.length()==3 && s2[0]==7), TRUE);
  s2.popn(2);
  TEST("s2.popn(2)", (s2.length()==1 && s2[0]==7), TRUE);
  s2.pushn(1, 3);  
  TEST("s2.pushn(1, 3)", 1, 1);
  TEST("s1.operator=(s2)", s1.operator=(s2), s2);
  TEST("s1.top()", (s1.top() == 1), TRUE);
  TEST("s2.position(7)", s2.position(7), 3);
  TEST("s1.find(33)", s1.find(33), FALSE);
  TEST("s2.operator[](3)", s2.operator[](3), 7);
  s2.clear();
  TEST("s2.clear()", 1, 1);
  TEST("s2.is_empty()", s2.is_empty(), TRUE);
  s2.resize(8);
  TEST("s2.resize(8)", 1, 1);
  TEST("s1.pushn(4, 8)", s1.pushn(4, 8), TRUE);
  TEST("s1.popn(13)", s1.popn(13), 7);
  s1.set_length(10);
  TEST("s1.set_length(10)", s1.length(), 10);
  s1.set_growth_ratio(2.0);
  TEST("s1.set_growth_ratio(2.0)", 1, 1);
  s1.set_alloc_size(50);
  TEST("s1.set_alloc_size(50)", 1, 1);
  Stack<int> s3(s1);
  TEST("Stack<int> s3 = s1", (s3==s1), TRUE);
}

void test_charP() {
  Stack<char*> s0;
  TEST("Stack<char*> s0", 1, 1);
  TEST("s0.length()", s0.length(), 0);
  Stack<char*> s1(4);
  TEST("Stack<char*> s1(4)", s1.capacity(), 4);
  Stack<char*> s2(4);
  TEST("Stack<char*> s2(4)", s1.capacity(), 4);
  s1.set_compare(&my_compare_charP);
  TEST ("s1.set_compare(&my_compare_charP)", 1,1);
  s1.pushn("AAA", 4);
  TEST("s1.pushn(\"AAA\", 4)", ((strcmp (s1[3],"AAA")==0) && (strcmp (s1[2],"AAA")==0) && (strcmp (s1[1],"AAA")==0) && (strcmp (s1[0],"AAA")==0)), 1);
  TEST("s1.length()", s1.length(), 4);
  s2.push("AAA");
  TEST("s2.push(\"AAA\")", (strcmp (s2[0],"AAA")==0), 1);
  TEST("s2.length()", s2.length(), 1);
  s2.push("AAA");
  TEST("s2.push(\"AAA\")", (strcmp (s2[0],"AAA")==0), 1);
  TEST("s2.length()", s2.length(), 2);
  s2.pushn("AAA", 2);
  TEST("s2.pushn(\"AAA\", 2)", 1, 1);
  TEST("s2.length()", s2.length(), 4);
  TEST("s1.operator==(s2)", s1.operator==(s2), TRUE);
  TEST("s2.operator!=(s1)", s2.operator!=(s1), FALSE);
  s2.pop();
  TEST("s2.pop()", (s2.length()==3 && (strcmp (s2[0], "AAA")==0)), 1);
  s2.popn(2);
  TEST("s2.popn(2)", (s2.length()==1 && (strcmp (s2[0], "AAA")==0)), 1);
  s2.pushn("BBB", 3);  
  TEST("s2.pushn(\"BBB\", 3)", 1, 1);
  TEST("s1.operator=(s2)", s1.operator=(s2), s2);
  TEST("s1.top()", (strcmp(s1.top(),"BBB")), 0);
  TEST("s2.position(\"AAA\")", s2.position("AAA"), 3);
  TEST("s1.find(\"ZZZ\")", s1.find("ZZZ"), FALSE);
  TEST("s2.operator[](3)", (strcmp (s2.operator[](3), "AAA")), 0);
  s2.clear();
  TEST("s2.clear()", 1, 1);
  TEST ("s2.length()", s2.length(), 0);
  TEST("s2.is_empty()", s2.is_empty(), TRUE);
  s2.resize(8);
  TEST("s2.resize(8)", 1, 1);
  TEST ("s2.capacity()", s2.capacity(), 8);
  TEST("s1.pushn(\"CCC\", 8)", s1.pushn("CCC", 8), TRUE);
  TEST("s1.popn(13)", strcmp (s1.popn(13), "AAA"), 0);
  s1.set_length(10);
  TEST("s1.set_length(10)", s1.length(), 10);
  s1.set_growth_ratio(2.0);
  TEST("s1.set_growth_ratio(2.0)", 1, 1);
  s1.set_alloc_size(50);
  TEST("s1.set_alloc_size(50)", 1, 1);
  Stack<char*> s3(s1);
  TEST("Stack<char*> s3 = s1", (s3==s1), TRUE);
}

void test_String () {
  String S1("AAA");
  Stack<String> s0;
  TEST("Stack<String> s0", 1, 1);
  TEST("s0.length()", s0.length(), 0);
  Stack<String> s1(4);
  TEST("Stack<String> s1(4)", s1.capacity(), 4);
  Stack<String> s2(4);
  TEST("Stack<String> s2(4)", s1.capacity(), 4);
  s1.pushn(String("AAA"), 4);
  TEST("s1.pushn(String(\"AAA\"), 4)", (s1[3]==S1 && s1[2]==S1 && s1[1]==S1 && s1[0]==S1), TRUE);
  TEST("s1.length()", s1.length(), 4);
  s2.push(String("AAA"));
  TEST("s2.push(String(\"AAA\"))", s2[0]==S1, TRUE);
  TEST("s2.length()", s2.length(), 1);
  s2.push(String("AAA"));
  TEST("s2.push(String(\"AAA\"))", s2[0]==S1, TRUE);
  TEST("s2.length()", s2.length(), 2);
  s2.pushn(String("AAA"), 2);
  TEST("s2.pushn(String(\"AAA\"), 2)", 1, 1);
  TEST("s2.length()", s2.length(), 4);
  TEST("s1.operator==(s2)", s1.operator==(s2), TRUE);
  TEST("s2.operator!=(s1)", s2.operator!=(s1), FALSE);
  s2.pop();
  TEST("s2.pop()", (s2.length()==3 && s2[0] == S1), 1);
  s2.popn(2);
  TEST("s2.popn(2)", (s2.length()==1 && s2[0] == S1), 1);
  s2.pushn(String("BBB"), 3);  
  TEST("s2.pushn(String(\"BBB\"), 3)", 1, 1);
  TEST("s1.operator=(s2)", s1.operator=(s2), s2);
  TEST("s1.top()", (strcmp(s1.top(),String("BBB"))), 0);
  TEST("s2.position(String(\"AAA\"))", s2.position(String("AAA")), 3);
  TEST("s1.find(String(\"ZZZ\"))", s1.find(String("ZZZ")), FALSE);
  TEST("s2.operator[](3)", (strcmp (s2.operator[](3), String("AAA"))), 0);
  s2.clear();
  TEST("s2.clear()", 1, 1);
  TEST ("s2.length()", s2.length(), 0);
  TEST("s2.is_empty()", s2.is_empty(), TRUE);
  s2.resize(8);
  TEST("s2.resize(8)", 1, 1);
  TEST ("s2.capacity()", s2.capacity(), 8);
  TEST("s1.pushn(String(\"CCC\"), 8)", s1.pushn(String("CCC"), 8), TRUE);
  TEST("s1.popn(13)", strcmp (s1.popn(13), String("AAA")), 0);
  s1.set_length(10);
  TEST("s1.set_length(10)", s1.length(), 10);
  s1.set_growth_ratio(2.0);
  TEST("s1.set_growth_ratio(2.0)", 1, 1);
  s1.set_alloc_size(50);
  TEST("s1.set_alloc_size(50)", 1, 1);
  Stack<String> s3(s1);
  TEST("Stack<String> s3 = s1", (s3==s1), TRUE);

}

int main (void) {
  START("Stack");
  test_int();
  test_charP();
  test_String();
  SUMMARY();
  return 0;
}

