//
// Copyright (C) 1991 Texas Instruments Incorporated.
//
// Permission is granted to any individual or institution to use, copy, modify,
// and distribute this software, provided that this complete copyright and
// permission notice is maintained, intact, in all copies and supporting
// documentation.
//
// Texas Instruments Incorporated provides this software "as is" without
// express or implied warranty.
//
// Created: MBN 10/10/89 -- Initial design and implementation
//
// The Iterator<Type> class provides  an independent mechanism  for maintaining
// the state associated with the current position of an instance of a container
// class.  In this manner, multiple iterators over the same instance of a class
// can be supported.  Each container class  that  supports the current position
// notion has some data structure that is used to represent the state. This may
// be as simple as a type long,  or something more  involved as with a union of
// of bit fields  or even another class instance.  In addition, each  container
// class  has a method  to get/set the  current   position. Utilization of this
// method with the  Iterator storage will facilitate storage  and retrieval  of
// the current position.
//
// The container-specific  data  structure used  to   hold the current position
// state is  all COOL  container  classes  will -- by   convention --  be named
// Class_state, where "Class"  is the name of the  container class header file.
// Thus, a user who includes Vector.h will declare an Iterator<Vector>, and the
// internal   data   structure that maintains    the  state  will   be of  type
// Vector_state.  In this manner, the Iterator<Type> class can be parameterized
// over the container  class name (ie.  Bit_Set, Vector,  etc.)  and allocate a
// data slot of the  appropriate type by concatenating  the Type name  with the
// string "_state" all without the user having  to know anything about internal
// implementation details.
//
// Each instance of a container  class has  a single slot  in the private  data
// section to maintain the current position. In  addition, each container class
// has a  public method that  returns a reference to this  iterator state  data
// structure.  The  six methods that support  current position functionality in
// all of  the   container classes  always  work  on  the current  position  as
// maintained in the private data section. A user can, at any point, change the
// current position state information  by utilizing this  method to get  and/or
// set the current position. Finally,  each state data structure implemented in
// every container class must support the assignment  of INVALID in some manner
// such that a state with  this value  (defined in <COOL/misc.h>) will cause an
// exception if used before set.
//
// There is only one private slot in the  Iterator<Type>  class that contains a
// single  element of type  Type##_state for the appropriate container class.
// The single constructor invokes the reset() method of the  container class to
// initialize the state.  The single method  provides   a means to  efficiently
// access the state of the object. All functionality that manipulates the state
// information remains in the appropriate container  class. In this manner, the
// Iterator<Type> class remains generic.

#ifndef ITERATORH				// If we have not defined class
#define ITERATORH				// Indicate class Iterator

#ifndef GENERIC_H
#include <cool/Generic.h>
#endif

template <class Type>
class Iterator<Type> {
private:
  Type ##_state value;				// Slot to hold iterator state

public:
  inline Iterator<Type> ();			// Constructor inits state
  inline Iterator<Type> (const Type##_state&);	// Constructor with reference
  ~Iterator<Type>() {};				// Destructor
#ifdef __cplusplus
  inline operator Type##_state();		// Return type-specific state
#else
  inline Type##_state operator Type##_state();	// Return type-specific state
#endif
};


// Iterator<Type> -- Simple constructor for Iterator class
// Input:            None
// Output:           None

template <class Type>
inline Iterator<Type>::Iterator<Type> () {
#if ISSAME(Type, List)
  this->value = NULL;				// If List class, init pointer
#else
  this->value = INVALID;			// Invalidate position state
#endif
}


// Iterator<Type> -- Constructor with a reference
// Input:            None
// Output:           None

template <class Type>
inline Iterator<Type>::Iterator<Type> (const Type##_state& s) {
  this->value = s;				// Assign state
}


// operator Type ##_state() -- Implicit conversion of Iterator<Type> to state
//                             that type defined in each COOL container class.
// Input:                      None
// Output:                     None
#ifdef __cplusplus
template <class Type>
inline Iterator<Type>::operator Type##_state () {
  return this->value;}				// Return state
#else
template <class Type>
inline Type##_state Iterator<Type>::operator Type##_state () {
  return this->value;}				// Return state
#endif

#endif                                          // End of ITERATORH

